/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.resolver;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.PackageNameFilter;
import org.verifyica.engine.common.Stopwatch;
import org.verifyica.engine.logger.Logger;
import org.verifyica.engine.logger.LoggerFactory;
import org.verifyica.engine.resolver.ResolverPredicates;
import org.verifyica.engine.support.ClassSupport;
import org.verifyica.engine.support.HierarchyTraversalMode;
import org.verifyica.engine.support.OrderSupport;

public class ClasspathRootSelectorResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathRootSelectorResolver.class);

    public void resolve(EngineDiscoveryRequest engineDiscoveryRequest, Map<Class<?>, Set<Method>> classMethodSet) {
        LOGGER.trace("resolve()");
        Stopwatch stopwatch = new Stopwatch();
        AtomicInteger classpathRootSelectorCount = new AtomicInteger();
        engineDiscoveryRequest.getSelectorsByType(ClasspathRootSelector.class).forEach(classpathRootSelector -> {
            classpathRootSelectorCount.incrementAndGet();
            LOGGER.trace("classpathRoot [%s]", classpathRootSelector.getClasspathRoot());
            List<Class<?>> testClasses = ClassSupport.findAllClasses(classpathRootSelector.getClasspathRoot(), ResolverPredicates.TEST_CLASS);
            List classNameFilters = engineDiscoveryRequest.getFiltersByType(ClassNameFilter.class);
            Predicate classNamePredicate = Filter.composeFilters((Collection)classNameFilters).toPredicate();
            List packageNameFilters = engineDiscoveryRequest.getFiltersByType(PackageNameFilter.class);
            Predicate packageNamePredicate = Filter.composeFilters((Collection)packageNameFilters).toPredicate();
            testClasses.forEach(testClass -> {
                if (classNamePredicate.test(testClass.getName()) && packageNamePredicate.test(testClass.getPackage().getName())) {
                    classMethodSet.computeIfAbsent((Class<?>)testClass, set -> new LinkedHashSet()).addAll(OrderSupport.orderMethods(ClassSupport.findMethods(testClass, ResolverPredicates.TEST_METHOD, HierarchyTraversalMode.BOTTOM_UP)));
                }
            });
        });
        LOGGER.trace("resolve() classpathRootSelectors [%d] elapsedTime [%d] ms", classpathRootSelectorCount.get(), stopwatch.elapsed().toMillis());
    }
}

