/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.resolver;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathResourceSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.DirectorySelector;
import org.junit.platform.engine.discovery.FileSelector;
import org.junit.platform.engine.discovery.IterationSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.ModuleSelector;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.discovery.UriSelector;
import org.verifyica.api.Argument;
import org.verifyica.api.Named;
import org.verifyica.api.Verifyica;
import org.verifyica.engine.api.ClassDefinition;
import org.verifyica.engine.api.MethodDefinition;
import org.verifyica.engine.common.Precondition;
import org.verifyica.engine.common.Stopwatch;
import org.verifyica.engine.descriptor.ArgumentTestDescriptor;
import org.verifyica.engine.descriptor.ClassTestDescriptor;
import org.verifyica.engine.descriptor.TestMethodTestDescriptor;
import org.verifyica.engine.exception.EngineException;
import org.verifyica.engine.exception.TestClassDefinitionException;
import org.verifyica.engine.filter.ClassDefinitionFilter;
import org.verifyica.engine.logger.Logger;
import org.verifyica.engine.logger.LoggerFactory;
import org.verifyica.engine.resolver.ClassSelectorResolver;
import org.verifyica.engine.resolver.ClasspathRootSelectorResolver;
import org.verifyica.engine.resolver.ConcreteClassDefinition;
import org.verifyica.engine.resolver.ConcreteMethodDefinition;
import org.verifyica.engine.resolver.MethodSelectorResolver;
import org.verifyica.engine.resolver.PackageSelectorResolver;
import org.verifyica.engine.resolver.ResolverPredicates;
import org.verifyica.engine.resolver.UniqueIdSelectorResolver;
import org.verifyica.engine.support.ClassSupport;
import org.verifyica.engine.support.DisplayNameSupport;
import org.verifyica.engine.support.HierarchyTraversalMode;
import org.verifyica.engine.support.OrderSupport;
import org.verifyica.engine.support.TagSupport;

public class EngineDiscoveryRequestResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(EngineDiscoveryRequestResolver.class);
    private static final List<Class<? extends DiscoverySelector>> DISCOVERY_SELECTORS_CLASSES = new ArrayList<Class<? extends DiscoverySelector>>();

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resolveSelectors(EngineDiscoveryRequest engineDiscoveryRequest, TestDescriptor testDescriptor) {
        LOGGER.trace("resolveSelectors()");
        Stopwatch stopwatch = new Stopwatch();
        HashMap testClassMethodSet = new HashMap();
        HashMap testClassArgumentMap = new HashMap();
        HashMap testClassArgumentIndexMap = new HashMap();
        try {
            ArrayList discoverySelectors = new ArrayList();
            if (LOGGER.isTraceEnabled()) {
                for (Class<? extends DiscoverySelector> discoverySelectorClass : DISCOVERY_SELECTORS_CLASSES) {
                    discoverySelectors.addAll(engineDiscoveryRequest.getSelectorsByType(discoverySelectorClass));
                }
                discoverySelectors.forEach(discoverySelector -> LOGGER.trace("discoverySelector [%s]", discoverySelector.toIdentifier().isPresent() ? discoverySelector.toIdentifier().get() : "null"));
            }
            new ClasspathRootSelectorResolver().resolve(engineDiscoveryRequest, testClassMethodSet);
            new PackageSelectorResolver().resolve(engineDiscoveryRequest, testClassMethodSet);
            new ClassSelectorResolver().resolve(engineDiscoveryRequest, testClassMethodSet);
            new MethodSelectorResolver().resolve(engineDiscoveryRequest, testClassMethodSet);
            new UniqueIdSelectorResolver().resolve(engineDiscoveryRequest, testClassMethodSet, testClassArgumentIndexMap);
            EngineDiscoveryRequestResolver.resolveTestArguments(testClassMethodSet, testClassArgumentMap, testClassArgumentIndexMap);
            ArrayList<ClassDefinition> classDefinitions = new ArrayList<ClassDefinition>();
            Set<Class<?>> orderedKeySet = OrderSupport.orderClasses(new LinkedHashSet(testClassMethodSet.keySet()));
            orderedKeySet.forEach(testClass -> {
                List testArguments = (List)testClassArgumentMap.get(testClass);
                Set<Method> testMethods = OrderSupport.orderMethods((Set)testClassMethodSet.get(testClass));
                int testArgumentParallelism = EngineDiscoveryRequestResolver.getTestArgumentParallelism(testClass);
                String testClassDisplayName = DisplayNameSupport.getDisplayName(testClass);
                Set<String> testClassTags = TagSupport.getTags(testClass);
                ArrayList<MethodDefinition> testMethodDefinitions = new ArrayList<MethodDefinition>();
                testMethods.forEach(testMethod -> {
                    String methodDisplayName = DisplayNameSupport.getDisplayName(testMethod);
                    testMethodDefinitions.add(new ConcreteMethodDefinition((Method)testMethod, methodDisplayName));
                });
                classDefinitions.add(new ConcreteClassDefinition((Class<?>)testClass, testClassDisplayName, testClassTags, (List<MethodDefinition>)testMethodDefinitions, testArguments, testArgumentParallelism));
            });
            EngineDiscoveryRequestResolver.pruneClassDefinitions(classDefinitions);
            ClassDefinitionFilter.filter(classDefinitions);
            EngineDiscoveryRequestResolver.buildEngineDescriptor(classDefinitions, testDescriptor);
            EngineDiscoveryRequestResolver.prunedDisabledTestMethods(testDescriptor);
        }
        catch (EngineException e) {
            try {
                throw e;
                catch (Throwable t) {
                    throw new EngineException(t);
                }
            }
            catch (Throwable throwable) {
                stopwatch.stop();
                LOGGER.trace("resolveSelectors() elapsedTime [%d] ms", stopwatch.elapsed().toMillis());
                throw throwable;
            }
        }
        stopwatch.stop();
        LOGGER.trace("resolveSelectors() elapsedTime [%d] ms", stopwatch.elapsed().toMillis());
    }

    private static void resolveTestArguments(Map<Class<?>, Set<Method>> testClassMethodSet, Map<Class<?>, List<Argument<?>>> testClassArgumentMap, Map<Class<?>, Set<Integer>> argumentIndexMap) throws Throwable {
        LOGGER.trace("resolveTestArguments()");
        Stopwatch stopwatch = new Stopwatch();
        for (Class<?> testClass : testClassMethodSet.keySet()) {
            List<Argument<?>> testArguments = EngineDiscoveryRequestResolver.getTestArguments(testClass);
            Set<Integer> testArgumentIndices = argumentIndexMap.get(testClass);
            if (testArgumentIndices != null) {
                ArrayList specificTestArguments = new ArrayList();
                for (int i = 0; i < testArguments.size(); ++i) {
                    if (!testArgumentIndices.contains(i)) continue;
                    specificTestArguments.add(testArguments.get(i));
                }
                testClassArgumentMap.put(testClass, specificTestArguments);
                continue;
            }
            testClassArgumentMap.put(testClass, testArguments);
        }
        LOGGER.trace("resolveTestArguments() elapsedTime [%d] ms", stopwatch.elapsed().toMillis());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<Argument<?>> getTestArguments(Class<?> testClass) throws Throwable {
        LOGGER.trace("getTestArguments() testClass [%s]", testClass.getName());
        Stopwatch stopwatch = new Stopwatch();
        ArrayList testArguments = new ArrayList();
        Object object = EngineDiscoveryRequestResolver.getArgumentSupplierMethod(testClass).invoke(null, (Object[])null);
        if (object == null) {
            return testArguments;
        }
        if (object.getClass().isArray()) {
            Object[] objects = (Object[])object;
            if (objects.length <= 0) return testArguments;
            int index = 0;
            for (Object o : objects) {
                if (o instanceof Argument) {
                    testArguments.add((Argument)o);
                } else {
                    String name = o instanceof Named ? ((Named)o).name() : (o != null && o.getClass().isEnum() ? ((Enum)o).name() : "argument[" + index + "]");
                    testArguments.add(Argument.of((String)name, (Object)o));
                }
                ++index;
            }
        } else {
            if (object instanceof Argument) {
                testArguments.add((Argument)object);
                return testArguments;
            }
            if (object instanceof Stream || object instanceof Iterable || object instanceof Iterator || object instanceof Enumeration) {
                Iterator iterator;
                if (object instanceof Enumeration) {
                    iterator = Collections.list((Enumeration)object).iterator();
                } else if (object instanceof Iterator) {
                    iterator = (Iterator)object;
                } else if (object instanceof Stream) {
                    Stream stream = (Stream)object;
                    iterator = stream.iterator();
                } else {
                    Iterable iterable = (Iterable)object;
                    iterator = iterable.iterator();
                }
                long index = 0L;
                while (iterator.hasNext()) {
                    Object o = iterator.next();
                    if (o instanceof Argument) {
                        testArguments.add((Argument)o);
                    } else {
                        String name = o instanceof Named ? ((Named)o).name() : (o != null && o.getClass().isEnum() ? ((Enum)o).name() : "argument[" + index + "]");
                        testArguments.add(Argument.of((String)name, o));
                    }
                    ++index;
                }
            } else if (object instanceof Named) {
                testArguments.add(Argument.of((String)((Named)object).name(), (Object)object));
            } else {
                testArguments.add(Argument.of((String)"argument[0]", (Object)object));
            }
        }
        LOGGER.trace("getTestArguments() elapsedTime [%d] ms", stopwatch.elapsed().toMillis());
        return testArguments;
    }

    private static Method getArgumentSupplierMethod(Class<?> testClass) {
        LOGGER.trace("getArgumentSupplierMethod() testClass [%s]", testClass.getName());
        List<Method> methods = ClassSupport.findMethods(testClass, ResolverPredicates.ARGUMENT_SUPPLIER_METHOD, HierarchyTraversalMode.BOTTOM_UP);
        EngineDiscoveryRequestResolver.validateSingleMethodPerClass(Verifyica.ArgumentSupplier.class, methods);
        return methods.get(0);
    }

    private static void pruneClassDefinitions(List<ClassDefinition> classDefinitions) {
        LOGGER.trace("pruneClassDefinitions()");
        classDefinitions.removeIf(classDefinition -> classDefinition.getArguments().isEmpty() || classDefinition.getTestMethodDefinitions().isEmpty());
    }

    private static void prunedDisabledTestMethods(TestDescriptor testDescriptor) {
        List prunedTestDescriptors = testDescriptor.getDescendants().stream().filter(testDescriptor1 -> testDescriptor1 instanceof TestMethodTestDescriptor && ((TestMethodTestDescriptor)((Object)testDescriptor1)).getTestMethod().isAnnotationPresent(Verifyica.Disabled.class)).collect(Collectors.toList());
        for (TestDescriptor prunedTestDescriptor : prunedTestDescriptors) {
            prunedTestDescriptor.removeFromHierarchy();
        }
    }

    private static void buildEngineDescriptor(List<ClassDefinition> classDefinitions, TestDescriptor testDescriptor) {
        LOGGER.trace("buildEngineDescriptor()");
        Stopwatch stopwatch = new Stopwatch();
        for (ClassDefinition classDefinition : classDefinitions) {
            Class<?> testClass = classDefinition.getTestClass();
            UniqueId classTestDescriptorUniqueId = testDescriptor.getUniqueId().append("class", testClass.getName());
            List<Method> prepareMethods = ClassSupport.findMethods(testClass, ResolverPredicates.PREPARE_METHOD, HierarchyTraversalMode.TOP_DOWN);
            EngineDiscoveryRequestResolver.validateSingleMethodPerClass(Verifyica.Prepare.class, prepareMethods);
            List<Method> concludeMethods = ClassSupport.findMethods(testClass, ResolverPredicates.CONCLUDE_METHOD, HierarchyTraversalMode.BOTTOM_UP);
            EngineDiscoveryRequestResolver.validateSingleMethodPerClass(Verifyica.Conclude.class, concludeMethods);
            ClassTestDescriptor classTestDescriptor = new ClassTestDescriptor(classTestDescriptorUniqueId, classDefinition.getDisplayName(), classDefinition.getTags(), testClass, classDefinition.getArgumentParallelism(), prepareMethods, concludeMethods);
            testDescriptor.addChild((TestDescriptor)classTestDescriptor);
            int testArgumentIndex = 0;
            for (Argument<?> testArgument : classDefinition.getArguments()) {
                UniqueId argumentTestDescriptorUniqueId = classTestDescriptorUniqueId.append("argument", String.valueOf(testArgumentIndex));
                List<Method> beforeAllMethods = ClassSupport.findMethods(testClass, ResolverPredicates.BEFORE_ALL_METHOD, HierarchyTraversalMode.TOP_DOWN);
                EngineDiscoveryRequestResolver.validateSingleMethodPerClass(Verifyica.BeforeAll.class, beforeAllMethods);
                List<Method> afterAllMethods = ClassSupport.findMethods(testClass, ResolverPredicates.AFTER_ALL_METHOD, HierarchyTraversalMode.BOTTOM_UP);
                EngineDiscoveryRequestResolver.validateSingleMethodPerClass(Verifyica.AfterAll.class, afterAllMethods);
                ArgumentTestDescriptor argumentTestDescriptor = new ArgumentTestDescriptor(argumentTestDescriptorUniqueId, testArgument.getName(), testArgumentIndex, testArgument, beforeAllMethods, afterAllMethods);
                classTestDescriptor.addChild((TestDescriptor)argumentTestDescriptor);
                for (MethodDefinition testMethodDefinition : classDefinition.getTestMethodDefinitions()) {
                    Method testMethod = testMethodDefinition.getMethod();
                    UniqueId testMethodDescriptorUniqueId = argumentTestDescriptorUniqueId.append("method", testMethod.getName());
                    List<Method> beforeEachMethods = ClassSupport.findMethods(testClass, ResolverPredicates.BEFORE_EACH_METHOD, HierarchyTraversalMode.TOP_DOWN);
                    EngineDiscoveryRequestResolver.validateSingleMethodPerClass(Verifyica.BeforeEach.class, beforeEachMethods);
                    List<Method> afterEachMethods = ClassSupport.findMethods(testClass, ResolverPredicates.AFTER_EACH_METHOD, HierarchyTraversalMode.BOTTOM_UP);
                    EngineDiscoveryRequestResolver.validateSingleMethodPerClass(Verifyica.AfterEach.class, beforeEachMethods);
                    TestMethodTestDescriptor testMethodTestDescriptor = new TestMethodTestDescriptor(testMethodDescriptorUniqueId, testMethodDefinition.getDisplayName(), beforeEachMethods, testMethodDefinition.getMethod(), afterEachMethods);
                    argumentTestDescriptor.addChild((TestDescriptor)testMethodTestDescriptor);
                }
                ++testArgumentIndex;
            }
        }
        LOGGER.trace("buildEngineDescriptor() elapsedTime [%d] ms", stopwatch.elapsed().toMillis());
    }

    private static void validateSingleMethodPerClass(Class<?> annotationClass, List<Method> methods) {
        Precondition.notNull(annotationClass, "annotationClass is null");
        if (methods != null) {
            HashSet classes = new HashSet();
            methods.forEach(method -> {
                if (classes.contains(method.getDeclaringClass())) {
                    String annotationDisplayName = "@Verifyica." + annotationClass.getSimpleName();
                    throw new TestClassDefinitionException(String.format("Test class [%s] contains more than one method annotated with [%s]", method.getDeclaringClass().getName(), annotationDisplayName));
                }
                classes.add(method.getDeclaringClass());
            });
        }
    }

    private static int getTestArgumentParallelism(Class<?> testClass) {
        LOGGER.trace("getTestArgumentParallelism() testClass [%s]", testClass.getName());
        Method argumentSupplierMethod = EngineDiscoveryRequestResolver.getArgumentSupplierMethod(testClass);
        Verifyica.ArgumentSupplier annotation = argumentSupplierMethod.getAnnotation(Verifyica.ArgumentSupplier.class);
        int parallelism = Math.max(annotation.parallelism(), 1);
        LOGGER.trace("testClass [%s] parallelism [%d]", testClass.getName(), parallelism);
        return parallelism;
    }

    static {
        DISCOVERY_SELECTORS_CLASSES.add(FileSelector.class);
        DISCOVERY_SELECTORS_CLASSES.add(DirectorySelector.class);
        DISCOVERY_SELECTORS_CLASSES.add(IterationSelector.class);
        DISCOVERY_SELECTORS_CLASSES.add(ClasspathResourceSelector.class);
        DISCOVERY_SELECTORS_CLASSES.add(ModuleSelector.class);
        DISCOVERY_SELECTORS_CLASSES.add(UriSelector.class);
        DISCOVERY_SELECTORS_CLASSES.add(ClasspathRootSelector.class);
        DISCOVERY_SELECTORS_CLASSES.add(PackageSelector.class);
        DISCOVERY_SELECTORS_CLASSES.add(ClassSelector.class);
        DISCOVERY_SELECTORS_CLASSES.add(MethodSelector.class);
        DISCOVERY_SELECTORS_CLASSES.add(UniqueIdSelector.class);
    }
}

