/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.resolver;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.discovery.MethodSelector;
import org.verifyica.engine.common.Stopwatch;
import org.verifyica.engine.logger.Logger;
import org.verifyica.engine.logger.LoggerFactory;
import org.verifyica.engine.resolver.ResolverPredicates;
import org.verifyica.engine.support.ClassSupport;
import org.verifyica.engine.support.HierarchyTraversalMode;
import org.verifyica.engine.support.OrderSupport;

public class MethodSelectorResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodSelectorResolver.class);

    public void resolve(EngineDiscoveryRequest engineDiscoveryRequest, Map<Class<?>, Set<Method>> classMethodSet) {
        LOGGER.trace("resolve()");
        Stopwatch stopwatch = new Stopwatch();
        AtomicInteger methodSelectorCount = new AtomicInteger();
        engineDiscoveryRequest.getSelectorsByType(MethodSelector.class).forEach(methodSelector -> {
            methodSelectorCount.incrementAndGet();
            Class testClass = methodSelector.getJavaClass();
            Method testMethod = methodSelector.getJavaMethod();
            LOGGER.trace("testClass [%s] testMethod [%s]", testClass.getName(), testMethod.getName());
            if (ResolverPredicates.TEST_CLASS.test(testClass) && ResolverPredicates.TEST_METHOD.test(testMethod)) {
                List<Method> testMethods = OrderSupport.orderMethods(ClassSupport.findMethods(testClass, ResolverPredicates.TEST_METHOD, HierarchyTraversalMode.BOTTOM_UP));
                for (Method method : testMethods) {
                    classMethodSet.computeIfAbsent(testClass, set -> new LinkedHashSet()).add(method);
                    if (!method.equals(testMethod)) continue;
                    break;
                }
            }
        });
        LOGGER.trace("resolve() methodSelectors [%d] elapsedTime [%d] ms", methodSelectorCount.get(), stopwatch.elapsed().toMillis());
    }
}

