/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.resolver;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.discovery.PackageSelector;
import org.verifyica.engine.common.Stopwatch;
import org.verifyica.engine.logger.Logger;
import org.verifyica.engine.logger.LoggerFactory;
import org.verifyica.engine.resolver.ResolverPredicates;
import org.verifyica.engine.support.ClassSupport;
import org.verifyica.engine.support.HierarchyTraversalMode;
import org.verifyica.engine.support.OrderSupport;

public class PackageSelectorResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(PackageSelectorResolver.class);

    public void resolve(EngineDiscoveryRequest engineDiscoveryRequest, Map<Class<?>, Set<Method>> classMethodSet) {
        LOGGER.trace("resolve()");
        Stopwatch stopwatch = new Stopwatch();
        AtomicInteger packageSelectorsCount = new AtomicInteger();
        engineDiscoveryRequest.getSelectorsByType(PackageSelector.class).forEach(packageSelector -> {
            packageSelectorsCount.incrementAndGet();
            String packageName = packageSelector.getPackageName();
            LOGGER.trace("packageName [%s]", packageName);
            List<Class<?>> testClasses = ClassSupport.findAllClasses(packageName, ResolverPredicates.TEST_CLASS);
            testClasses.forEach(testClass -> classMethodSet.computeIfAbsent((Class<?>)testClass, set -> new LinkedHashSet()).addAll(OrderSupport.orderMethods(ClassSupport.findMethods(testClass, ResolverPredicates.TEST_METHOD, HierarchyTraversalMode.BOTTOM_UP))));
        });
        LOGGER.trace("resolve() packageSelectors [%d] elapsedTime [%d] ms", packageSelectorsCount.get(), stopwatch.elapsed().toMillis());
    }
}

