/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.resolver;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.verifyica.engine.common.Stopwatch;
import org.verifyica.engine.descriptor.ClassTestDescriptor;
import org.verifyica.engine.exception.UncheckedClassNotFoundException;
import org.verifyica.engine.logger.Logger;
import org.verifyica.engine.logger.LoggerFactory;
import org.verifyica.engine.resolver.ResolverPredicates;
import org.verifyica.engine.support.ClassSupport;
import org.verifyica.engine.support.HierarchyTraversalMode;
import org.verifyica.engine.support.OrderSupport;

public class UniqueIdSelectorResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(UniqueIdSelectorResolver.class);

    public void resolve(EngineDiscoveryRequest engineDiscoveryRequest, Map<Class<?>, Set<Method>> classMethodSet, Map<Class<?>, Set<Integer>> argumentIndexMap) {
        LOGGER.trace("resolve()");
        Stopwatch stopwatch = new Stopwatch();
        AtomicInteger uniqueIdSelectorCount = new AtomicInteger();
        engineDiscoveryRequest.getSelectorsByType(UniqueIdSelector.class).forEach(uniqueIdSelector -> {
            uniqueIdSelectorCount.incrementAndGet();
            UniqueId uniqueId = uniqueIdSelector.getUniqueId();
            List segments = uniqueId.getSegments();
            LOGGER.trace("uniqueId [%s]", uniqueId);
            if (segments.size() == 3) {
                UniqueId.Segment classSegment = (UniqueId.Segment)segments.get(1);
                UniqueId.Segment argumentSegment = (UniqueId.Segment)segments.get(2);
                Class<?> testClass = null;
                try {
                    testClass = Thread.currentThread().getContextClassLoader().loadClass(classSegment.getValue());
                }
                catch (ClassNotFoundException e) {
                    UncheckedClassNotFoundException.throwUnchecked(e);
                }
                classMethodSet.computeIfAbsent(testClass, set -> new LinkedHashSet()).addAll(OrderSupport.orderMethods(ClassSupport.findMethods(testClass, ResolverPredicates.TEST_METHOD, HierarchyTraversalMode.BOTTOM_UP)));
                argumentIndexMap.computeIfAbsent(testClass, clazz -> new LinkedHashSet()).add(Integer.parseInt(argumentSegment.getValue()));
            } else {
                segments.forEach(segment -> {
                    String segmentType = segment.getType();
                    if (segmentType.equals(ClassTestDescriptor.class.getName())) {
                        String javaClassName = segment.getValue();
                        Class<?> testClass = null;
                        try {
                            testClass = Thread.currentThread().getContextClassLoader().loadClass(javaClassName);
                        }
                        catch (ClassNotFoundException e) {
                            UncheckedClassNotFoundException.throwUnchecked(e);
                        }
                        classMethodSet.computeIfAbsent(testClass, set -> new LinkedHashSet()).addAll(ClassSupport.findMethods(testClass, ResolverPredicates.TEST_METHOD, HierarchyTraversalMode.BOTTOM_UP));
                    }
                });
            }
        });
        LOGGER.trace("resolve() uniqueIdSelectors [%d] elapsedTime [%d] ms", uniqueIdSelectorCount.get(), stopwatch.elapsed().toMillis());
    }
}

