/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.support;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.junit.platform.commons.support.ReflectionSupport;
import org.verifyica.engine.common.Precondition;
import org.verifyica.engine.exception.UncheckedURISyntaxException;
import org.verifyica.engine.support.HierarchyTraversalMode;

public class ClassSupport {
    private static final Lock LOCK = new ReentrantLock(true);
    private static List<URI> URIS;

    private ClassSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<URI> getClasspathURIs() {
        LOCK.lock();
        try {
            if (URIS == null) {
                String[] paths;
                URIS = new ArrayList<URI>();
                LinkedHashSet<URI> uriSet = new LinkedHashSet<URI>();
                String classpath = System.getProperty("java.class.path");
                for (String path : paths = classpath.split(File.pathSeparator)) {
                    uriSet.add(new File(path).toURI());
                }
                URIS.addAll(uriSet);
            }
            List<URI> list = URIS;
            return list;
        }
        finally {
            LOCK.unlock();
        }
    }

    public static List<Class<?>> findAllClasses(Predicate<Class<?>> predicate) {
        Precondition.notNull(predicate, "predicate is null");
        LinkedHashSet set = new LinkedHashSet();
        ClassSupport.getClasspathURIs().forEach(uri -> set.addAll(ReflectionSupport.findAllClassesInClasspathRoot((URI)uri, (Predicate)predicate, classNameFilter -> true)));
        ArrayList list = new ArrayList(set);
        list.sort(Comparator.comparing(Class::getName));
        return list;
    }

    public static List<Class<?>> findNestedClasses(Class<?> clazz, Predicate<Class<?>> predicate) {
        return new ArrayList(ReflectionSupport.findNestedClasses(clazz, predicate));
    }

    public static List<Class<?>> findAllClasses(URI uri, Predicate<Class<?>> predicate) {
        Precondition.notNull(uri, "uri is null");
        Precondition.notNull(predicate, "predicate is null");
        return new ArrayList(ReflectionSupport.findAllClassesInClasspathRoot((URI)uri, predicate, classNameFilter -> true));
    }

    public static List<Class<?>> findAllClasses(String packageName, Predicate<Class<?>> predicate) {
        Precondition.notNull(packageName, "packageName is null");
        Precondition.notNull(predicate, "predicate is null");
        return ClassSupport.findAllClasses(predicate).stream().filter(clazz -> packageName.equals(clazz.getPackage().getName())).collect(Collectors.toList());
    }

    public static List<Field> findFields(Class<?> clazz, Predicate<Field> predicate, HierarchyTraversalMode hierarchyTraversalMode) {
        Precondition.notNull(clazz, "clazz is null");
        Precondition.notNull(predicate, "predicate is null");
        Precondition.notNull((Object)hierarchyTraversalMode, "hierarchyTraversalMode is null");
        return new ArrayList<Field>(ReflectionSupport.findFields(clazz, predicate, (org.junit.platform.commons.support.HierarchyTraversalMode)HierarchyTraversalMode.decode(hierarchyTraversalMode)));
    }

    public static List<Method> findMethods(Class<?> clazz, Predicate<Method> predicate, HierarchyTraversalMode hierarchyTraversalMode) {
        Precondition.notNull(clazz, "clazz is null");
        Precondition.notNull(predicate, "predicate is null");
        Precondition.notNull((Object)hierarchyTraversalMode, "hierarchyTraversalMode is null");
        return new ArrayList<Method>(ReflectionSupport.findMethods(clazz, predicate, (org.junit.platform.commons.support.HierarchyTraversalMode)HierarchyTraversalMode.decode(hierarchyTraversalMode)));
    }

    public static List<URI> findAllResources(Predicate<String> predicate) throws IOException {
        Precondition.notNull(predicate, "predicate is null");
        ArrayList<URI> uris = new ArrayList<URI>();
        try {
            for (URI uri : ClassSupport.getClasspathURIs()) {
                Path path = Paths.get(uri);
                if (Files.isDirectory(path, new LinkOption[0])) {
                    ClassSupport.scanDirectory(path, predicate, uris);
                    continue;
                }
                if (!path.toString().toLowerCase(Locale.ENGLISH).endsWith(".jar")) continue;
                ClassSupport.scanJarFile(path, predicate, uris);
            }
        }
        catch (URISyntaxException e) {
            UncheckedURISyntaxException.throwUnchecked(e);
        }
        return uris;
    }

    private static void scanDirectory(Path directoryPath, Predicate<String> predicate, List<URI> uris) throws IOException {
        Files.walkFileTree(directoryPath, new PathSimpleFileVisitor(predicate, uris));
    }

    private static void scanJarFile(Path jarPath, Predicate<String> predicate, List<URI> uris) throws IOException, URISyntaxException {
        try (JarFile jarFile = new JarFile(jarPath.toFile().getPath());){
            Enumeration<JarEntry> jarEntryEnumeration = jarFile.entries();
            while (jarEntryEnumeration.hasMoreElements()) {
                JarEntry jarEntry = jarEntryEnumeration.nextElement();
                if (jarEntry.isDirectory() || !predicate.test(jarEntry.getName())) continue;
                uris.add(URI.create("jar:" + jarPath.toUri() + "!/" + jarEntry.getName()));
            }
        }
    }

    private static class PathSimpleFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Predicate<String> predicate;
        private final List<URI> uris;

        public PathSimpleFileVisitor(Predicate<String> predicate, List<URI> uris) {
            this.predicate = predicate;
            this.uris = uris;
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
            if (basicFileAttributes.isRegularFile() && this.predicate.test(path.getFileName().toString())) {
                this.uris.add(path.toUri());
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path path, IOException ioException) {
            return FileVisitResult.CONTINUE;
        }
    }
}

