/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.support;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.verifyica.engine.common.Precondition;

public class ObjectSupport {
    private ObjectSupport() {
    }

    public static <T> T createObject(Class<?> clazz) throws Throwable {
        Precondition.notNull(clazz, "clazz is null");
        return (T)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static String toString(Method ... methods) {
        Precondition.notNull(methods, "methods is null");
        return ObjectSupport.toString(Arrays.stream(methods).collect(Collectors.toList()));
    }

    public static String toString(List<Method> methods) {
        Precondition.notNull(methods, "methods is null");
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Method> iterator = methods.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().getName());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }
}

