/*
 * Decompiled with CFR 0.152.
 */
package 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge;

import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.ThreadFeature;
import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.ThreadProviderConfig;
import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.ThreadTool;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

class ThreadBuilders8 {
    private ThreadBuilders8() {
    }

    private static class VirtualThreadFactory
    extends BaseThreadFactory {
        VirtualThreadFactory(String name, long start, Thread.UncaughtExceptionHandler uhe) {
            super(name, start, uhe);
        }

        @Override
        public Thread newThread(Runnable task) {
            Objects.requireNonNull(task);
            String name = this.nextThreadName();
            Thread thread = new Thread(task, name);
            thread.setDaemon(true);
            Thread.UncaughtExceptionHandler uhe = this.uncaughtExceptionHandler();
            if (uhe != null) {
                thread.setUncaughtExceptionHandler(uhe);
            }
            return thread;
        }
    }

    private static class PlatformThreadFactory
    extends BaseThreadFactory {
        private final ThreadGroup group;
        private final boolean daemonChanged;
        private final boolean daemon;
        private final int priority;
        private final long stackSize;

        PlatformThreadFactory(ThreadGroup group, String name, long start, boolean daemonChanged, boolean daemon, int priority, long stackSize, Thread.UncaughtExceptionHandler uhe) {
            super(name, start, uhe);
            this.group = group;
            this.daemonChanged = daemonChanged;
            this.daemon = daemon;
            this.priority = priority;
            this.stackSize = stackSize;
        }

        @Override
        String nextThreadName() {
            String name = super.nextThreadName();
            return name != null ? name : ThreadTool.genThreadName();
        }

        @Override
        public Thread newThread(Runnable task) {
            Thread.UncaughtExceptionHandler uhe;
            Objects.requireNonNull(task);
            String name = this.nextThreadName();
            Thread thread = new Thread(this.group, task, name, this.stackSize);
            if (this.daemonChanged) {
                thread.setDaemon(this.daemon);
            }
            if (this.priority != 0) {
                thread.setPriority(this.priority);
            }
            if ((uhe = this.uncaughtExceptionHandler()) != null) {
                thread.setUncaughtExceptionHandler(uhe);
            }
            return thread;
        }
    }

    private static abstract class BaseThreadFactory
    implements ThreadFactory {
        private final String name;
        private final Thread.UncaughtExceptionHandler uhe;
        private final boolean hasCounter;
        private final AtomicLong count = new AtomicLong();

        BaseThreadFactory(String name, long start, Thread.UncaughtExceptionHandler uhe) {
            this.name = name;
            if (name != null && start >= 0L) {
                this.hasCounter = true;
                this.count.set(start);
            } else {
                this.hasCounter = false;
            }
            this.uhe = uhe;
        }

        Thread.UncaughtExceptionHandler uncaughtExceptionHandler() {
            return this.uhe;
        }

        String nextThreadName() {
            if (this.hasCounter) {
                return this.name + this.count.getAndIncrement();
            }
            return this.name;
        }
    }

    static final class VirtualThreadBuilder
    extends BaseThreadBuilder
    implements ThreadTool.Builder.OfVirtual {
        VirtualThreadBuilder() {
        }

        @Override
        public ThreadTool.Builder.OfVirtual name(String name) {
            this.setName(name);
            return this;
        }

        @Override
        public ThreadTool.Builder.OfVirtual name(String prefix, long start) {
            this.setName(prefix, start);
            return this;
        }

        @Override
        public ThreadTool.Builder.OfVirtual inheritInheritableThreadLocals(boolean inherit) {
            return this;
        }

        @Override
        public ThreadTool.Builder.OfVirtual uncaughtExceptionHandler(Thread.UncaughtExceptionHandler ueh) {
            this.setUncaughtExceptionHandler(ueh);
            return this;
        }

        @Override
        public Thread unstarted(Runnable task) {
            Objects.requireNonNull(task);
            Thread thread = new Thread(task, this.nextThreadName());
            Thread.UncaughtExceptionHandler uhe = this.uncaughtExceptionHandler();
            if (uhe != null) {
                thread.setUncaughtExceptionHandler(uhe);
            }
            return thread;
        }

        @Override
        public Thread start(Runnable task) {
            Thread thread = this.unstarted(task);
            thread.start();
            return thread;
        }

        @Override
        public ThreadFactory factory() {
            return new VirtualThreadFactory(this.name(), this.counter(), this.uncaughtExceptionHandler());
        }
    }

    static final class PlatformThreadBuilder
    extends BaseThreadBuilder
    implements ThreadTool.Builder.OfPlatform {
        private ThreadProviderConfig config;
        private ThreadGroup group;
        private boolean daemon;
        private boolean daemonChanged;
        private int priority;
        private long stackSize;

        PlatformThreadBuilder(ThreadProviderConfig config) {
            this.config = config;
        }

        @Override
        String nextThreadName() {
            String name = super.nextThreadName();
            return name != null ? name : ThreadTool.genThreadName();
        }

        @Override
        public ThreadTool.Builder.OfPlatform name(String name) {
            this.setName(name);
            return this;
        }

        @Override
        public ThreadTool.Builder.OfPlatform name(String prefix, long start) {
            this.setName(prefix, start);
            return this;
        }

        @Override
        public ThreadTool.Builder.OfPlatform inheritInheritableThreadLocals(boolean inherit) {
            if (!inherit) {
                this.config.enforceCompatibilityPolicy(ThreadFeature.INHERIT_INHERITABLE_THREAD_LOCALS);
            }
            return this;
        }

        @Override
        public ThreadTool.Builder.OfPlatform uncaughtExceptionHandler(Thread.UncaughtExceptionHandler ueh) {
            this.setUncaughtExceptionHandler(ueh);
            return this;
        }

        @Override
        public ThreadTool.Builder.OfPlatform group(ThreadGroup group) {
            this.group = Objects.requireNonNull(group);
            return this;
        }

        @Override
        public ThreadTool.Builder.OfPlatform daemon(boolean on) {
            this.daemon = on;
            this.daemonChanged = true;
            return this;
        }

        @Override
        public ThreadTool.Builder.OfPlatform priority(int priority) {
            if (priority < 1 || priority > 10) {
                throw new IllegalArgumentException();
            }
            this.priority = priority;
            return this;
        }

        @Override
        public ThreadTool.Builder.OfPlatform stackSize(long stackSize) {
            if (stackSize < 0L) {
                throw new IllegalArgumentException();
            }
            this.stackSize = stackSize;
            return this;
        }

        @Override
        public Thread unstarted(Runnable task) {
            Thread.UncaughtExceptionHandler uhe;
            Objects.requireNonNull(task);
            String name = this.nextThreadName();
            Thread thread = new Thread(this.group, task, name, this.stackSize);
            if (this.daemonChanged) {
                thread.setDaemon(this.daemon);
            }
            if (this.priority != 0) {
                thread.setPriority(this.priority);
            }
            if ((uhe = this.uncaughtExceptionHandler()) != null) {
                thread.setUncaughtExceptionHandler(uhe);
            }
            return thread;
        }

        @Override
        public Thread start(Runnable task) {
            Thread thread = this.unstarted(task);
            thread.start();
            return thread;
        }

        @Override
        public ThreadFactory factory() {
            return new PlatformThreadFactory(this.group, this.name(), this.counter(), this.daemonChanged, this.daemon, this.priority, this.stackSize, this.uncaughtExceptionHandler());
        }
    }

    private static class BaseThreadBuilder {
        private String name;
        private long counter;
        private Thread.UncaughtExceptionHandler uhe;

        private BaseThreadBuilder() {
        }

        String name() {
            return this.name;
        }

        long counter() {
            return this.counter;
        }

        Thread.UncaughtExceptionHandler uncaughtExceptionHandler() {
            return this.uhe;
        }

        String nextThreadName() {
            if (this.name != null && this.counter >= 0L) {
                return this.name + this.counter++;
            }
            return this.name;
        }

        void setName(String name) {
            this.name = Objects.requireNonNull(name);
            this.counter = -1L;
        }

        void setName(String prefix, long start) {
            Objects.requireNonNull(prefix);
            if (start < 0L) {
                throw new IllegalArgumentException("'start' is negative");
            }
            this.name = prefix;
            this.counter = start;
        }

        void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler ueh) {
            this.uhe = Objects.requireNonNull(ueh);
        }
    }
}

