/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.common;

import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.ThreadTool;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.verifyica.engine.common.Precondition;
import org.verifyica.engine.logger.Logger;
import org.verifyica.engine.logger.LoggerFactory;
import org.verifyica.engine.support.ThreadSupport;

public class FairExecutorService
extends AbstractExecutorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FairExecutorService.class);
    private final int blockingQueueCount;
    private final List<BlockingQueue<Runnable>> blockingQueues;
    private final List<Thread> threads;
    private final AtomicInteger blockingQueueIndex;
    private final AtomicBoolean isShutdown;

    public FairExecutorService(int parallelism) {
        Precondition.isTrue(parallelism > 0, "parallelism is less than 1");
        LOGGER.trace("parallelism [%d]", parallelism);
        if (ThreadTool.hasVirtualThreads()) {
            LOGGER.trace("using virtual threads");
        } else {
            LOGGER.trace("using platform threads");
        }
        this.blockingQueueCount = parallelism;
        this.blockingQueues = new ArrayList<BlockingQueue<Runnable>>(parallelism);
        this.threads = new ArrayList<Thread>(parallelism);
        this.blockingQueueIndex = new AtomicInteger(0);
        this.isShutdown = new AtomicBoolean();
        for (int i = 0; i < parallelism; ++i) {
            LinkedBlockingQueue blockingQueue = new LinkedBlockingQueue(10);
            this.blockingQueues.add(blockingQueue);
            Thread thread = ThreadSupport.newThread(() -> this.processBlockingQueue(blockingQueue));
            this.threads.add(thread);
            thread.start();
        }
    }

    @Override
    public void shutdown() {
        this.isShutdown.set(true);
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.isShutdown.set(true);
        ArrayList<Runnable> remainingRunnables = new ArrayList<Runnable>();
        for (BlockingQueue<Runnable> queue : this.blockingQueues) {
            queue.drainTo(remainingRunnables);
        }
        return remainingRunnables;
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown.get();
    }

    @Override
    public boolean isTerminated() {
        return this.threads.stream().noneMatch(Thread::isAlive);
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long endTime = System.nanoTime() + unit.toNanos(timeout);
        for (Thread thread : this.threads) {
            long timeLeft = endTime - System.nanoTime();
            if (timeLeft <= 0L) break;
            thread.join(timeLeft / 1000000L, (int)(timeLeft % 1000000L));
        }
        return this.isTerminated();
    }

    @Override
    public void execute(Runnable runnable) {
        Precondition.notNull(runnable, "runnable is null");
        int index = this.blockingQueueIndex.getAndUpdate(i -> (i + 1) % this.blockingQueueCount);
        try {
            this.blockingQueues.get(index).put(runnable);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void processBlockingQueue(BlockingQueue<Runnable> blockingQueue) {
        while (!this.isShutdown.get()) {
            try {
                Runnable runnable = blockingQueue.poll(100L, TimeUnit.MILLISECONDS);
                if (runnable == null) continue;
                runnable.run();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

