/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.common;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Stopwatch {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private long startNanoTime;
    private Long stopNanoTime;

    public Stopwatch() {
        this.reset();
    }

    public Stopwatch reset() {
        this.readWriteLock.writeLock().lock();
        try {
            this.startNanoTime = System.nanoTime();
            this.stopNanoTime = null;
            Stopwatch stopwatch = this;
            return stopwatch;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public Stopwatch stop() {
        this.readWriteLock.writeLock().lock();
        try {
            this.stopNanoTime = System.nanoTime();
            Stopwatch stopwatch = this;
            return stopwatch;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public Duration elapsedTime() {
        this.readWriteLock.readLock().lock();
        try {
            if (this.stopNanoTime == null) {
                Duration duration = Duration.ofNanos(System.nanoTime() - this.startNanoTime);
                return duration;
            }
            Duration duration = Duration.ofNanos(this.stopNanoTime - this.startNanoTime);
            return duration;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public String toString() {
        return String.valueOf(this.elapsedTime().toNanos());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Stopwatch stopwatch = (Stopwatch)o;
        this.readWriteLock.readLock().lock();
        try {
            boolean bl = this.startNanoTime == stopwatch.startNanoTime && Objects.equals(this.stopNanoTime, stopwatch.stopNanoTime);
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public int hashCode() {
        this.readWriteLock.readLock().lock();
        try {
            int n = Objects.hash(this.startNanoTime, this.stopNanoTime);
            return n;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }
}

