/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.common;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class Streams {
    private static List<OutputStream> OUTPUT_STREAMS = null;
    private static OutputStream LAST_OUTPUT_STREAM = null;

    private Streams() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fix() {
        Class<Streams> clazz = Streams.class;
        synchronized (Streams.class) {
            if (OUTPUT_STREAMS == null) {
                OUTPUT_STREAMS = new ArrayList<OutputStream>();
                System.setErr(new PrintStream(new FixedStream(System.err)));
                System.setOut(new PrintStream(new FixedStream(System.out)));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static class FixedStream
    extends OutputStream {
        private final OutputStream outputStream;

        private FixedStream(OutputStream outputStream) {
            this.outputStream = outputStream;
            OUTPUT_STREAMS.add(this);
        }

        @Override
        public void write(int b) throws IOException {
            if (LAST_OUTPUT_STREAM != this) {
                this.flushAndSwap();
            }
            this.outputStream.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (LAST_OUTPUT_STREAM != this) {
                this.flushAndSwap();
            }
            this.outputStream.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (LAST_OUTPUT_STREAM != this) {
                this.flushAndSwap();
            }
            this.outputStream.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.outputStream.flush();
        }

        @Override
        public void close() throws IOException {
            this.outputStream.close();
        }

        private void flushAndSwap() throws IOException {
            if (LAST_OUTPUT_STREAM != null) {
                LAST_OUTPUT_STREAM.flush();
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            LAST_OUTPUT_STREAM = this;
        }
    }
}

