/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.context;

import java.util.Objects;
import org.verifyica.api.Argument;
import org.verifyica.api.ArgumentContext;
import org.verifyica.api.ClassContext;
import org.verifyica.api.Configuration;
import org.verifyica.engine.common.Precondition;
import org.verifyica.engine.context.AbstractContext;

public class ConcreteArgumentContext
extends AbstractContext
implements ArgumentContext {
    private final ClassContext classContext;
    private final int argumentIndex;
    private final Argument<?> argument;

    public ConcreteArgumentContext(ClassContext classContext, int argumentIndex, Argument<?> argument) {
        this.classContext = classContext;
        this.argumentIndex = argumentIndex;
        this.argument = argument;
    }

    public ClassContext getClassContext() {
        return this.classContext;
    }

    @Override
    public Configuration getConfiguration() {
        return this.classContext.getConfiguration();
    }

    public int getTestArgumentIndex() {
        return this.argumentIndex;
    }

    public Argument<?> getTestArgument() {
        return this.argument;
    }

    public <V> Argument<V> getTestArgument(Class<V> type) {
        Precondition.notNull(type, "type is null");
        if (this.argument.getPayload() == null) {
            return this.argument;
        }
        if (type.isAssignableFrom(this.argument.getPayload().getClass())) {
            return this.argument;
        }
        throw new ClassCastException(String.format("Cannot cast Argument<%s> to Argument<%s>", this.argument.getPayload().getClass().getName(), type.getName()));
    }

    public <V> V getTestArgumentPayload() {
        return (V)(this.argument != null ? this.argument.getPayload() : null);
    }

    public <V> V getTestArgumentPayload(Class<V> type) {
        Precondition.notNull(type, "type is null");
        return (V)(this.argument != null ? this.argument.getPayload(type) : null);
    }

    public String toString() {
        return "ConcreteArgumentContext{classContext=" + this.classContext + ", argumentIndex=" + this.argumentIndex + ", argument=" + this.argument + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConcreteArgumentContext that = (ConcreteArgumentContext)object;
        return this.argumentIndex == that.argumentIndex && Objects.equals(this.classContext, that.classContext) && Objects.equals(this.argument, that.argument);
    }

    public int hashCode() {
        return Objects.hash(this.classContext, this.argumentIndex, this.argument);
    }
}

