/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.descriptor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.verifyica.api.ArgumentContext;
import org.verifyica.api.Assumptions;
import org.verifyica.api.ClassInterceptor;
import org.verifyica.api.SkipExecution;
import org.verifyica.engine.descriptor.TestDescriptorStatus;
import org.verifyica.engine.descriptor.TestableTestDescriptor;
import org.verifyica.engine.inject.Inject;
import org.verifyica.engine.inject.Named;
import org.verifyica.engine.logger.Logger;
import org.verifyica.engine.logger.LoggerFactory;

public class TestMethodTestDescriptor
extends TestableTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestMethodTestDescriptor.class);
    private final List<Method> beforeEachMethods;
    private final Method testMethod;
    private final List<Method> afterEachMethods;
    private final List<Object> invocationArguments;
    private final List<Throwable> throwables;
    @Inject
    @Named(value="engineExecutionListener")
    private EngineExecutionListener engineExecutionListener;
    @Inject
    @Named(value="classInterceptors")
    private List<ClassInterceptor> classInterceptors;
    @Inject
    @Named(value="classInterceptorsReversed")
    private List<ClassInterceptor> classInterceptorsReversed;
    @Inject
    @Named(value="argumentContext")
    private ArgumentContext argumentContext;
    private boolean markSkipped;

    public TestMethodTestDescriptor(UniqueId uniqueId, String displayName, List<Method> beforeEachMethods, Method testMethod, List<Method> afterEachMethods) {
        super(uniqueId, displayName);
        this.beforeEachMethods = beforeEachMethods;
        this.testMethod = testMethod;
        this.afterEachMethods = afterEachMethods;
        this.invocationArguments = new ArrayList<Object>();
        this.throwables = new ArrayList<Throwable>();
    }

    @Override
    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.TEST;
    }

    public Optional<TestSource> getSource() {
        return Optional.of(MethodSource.from((Method)this.testMethod));
    }

    public Method getTestMethod() {
        return this.testMethod;
    }

    @Override
    public TestMethodTestDescriptor test() {
        try {
            this.invocationArguments.add(this.argumentContext.getTestArgument().getPayload());
            this.invocationArguments.add(this.argumentContext.getTestArgument());
            this.invocationArguments.add(this.argumentContext);
            this.engineExecutionListener.executionStarted((TestDescriptor)this);
            State state = State.START;
            block8: while (state != State.END) {
                LOGGER.trace("testDescriptor [%s] state [%s]", new Object[]{this, state});
                switch (state.ordinal()) {
                    case 0: {
                        state = State.BEFORE_EACH;
                        continue block8;
                    }
                    case 1: {
                        state = this.doBeforeEach();
                        continue block8;
                    }
                    case 2: {
                        state = this.doTest();
                        continue block8;
                    }
                    case 3: {
                        state = this.doAfterEach();
                        continue block8;
                    }
                }
                throw new IllegalStateException(String.format("Invalid State [%s]", new Object[]{state}));
            }
            if (this.markSkipped) {
                this.setTestDescriptorStatus(TestDescriptorStatus.skipped());
                this.engineExecutionListener.executionSkipped((TestDescriptor)this, "Skipped");
            } else {
                TestDescriptorStatus testDescriptorStatus;
                TestExecutionResult testExecutionResult;
                if (this.throwables.isEmpty()) {
                    testExecutionResult = TestExecutionResult.successful();
                    testDescriptorStatus = TestDescriptorStatus.passed();
                } else {
                    testExecutionResult = TestExecutionResult.failed((Throwable)this.throwables.get(0));
                    testDescriptorStatus = TestDescriptorStatus.failed(this.throwables.get(0));
                }
                this.setTestDescriptorStatus(testDescriptorStatus);
                this.engineExecutionListener.executionFinished((TestDescriptor)this, testExecutionResult);
            }
        }
        catch (Throwable t) {
            TestMethodTestDescriptor.printStackTrace(t);
            this.setTestDescriptorStatus(TestDescriptorStatus.failed(t));
            this.engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)t));
        }
        return this;
    }

    @Override
    public void skip() {
        this.engineExecutionListener.executionStarted((TestDescriptor)this);
        this.engineExecutionListener.executionSkipped((TestDescriptor)this, "Skipped");
        this.setTestDescriptorStatus(TestDescriptorStatus.skipped());
    }

    private State doBeforeEach() {
        Throwable throwable = null;
        try {
            for (ClassInterceptor classInterceptor : this.classInterceptors) {
                classInterceptor.preBeforeEach(this.argumentContext);
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        if (!this.markSkipped && throwable == null) {
            try {
                for (Method method : this.beforeEachMethods) {
                    TestMethodTestDescriptor.invoke(method, this.argumentContext.getClassContext().getTestInstance(), this.invocationArguments);
                }
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Assumptions.Failed || cause instanceof SkipExecution) {
                    this.markSkipped = true;
                } else {
                    throwable = cause;
                }
            }
            catch (Throwable t) {
                throwable = t;
            }
        }
        try {
            for (ClassInterceptor classInterceptor : this.classInterceptorsReversed) {
                classInterceptor.postBeforeEach(this.argumentContext, throwable);
            }
        }
        catch (Throwable t) {
            throwable = t;
            TestMethodTestDescriptor.printStackTrace(t);
            this.throwables.add(t);
        }
        if (this.markSkipped) {
            return State.AFTER_EACH;
        }
        if (throwable == null) {
            return State.TEST;
        }
        return State.AFTER_EACH;
    }

    private State doTest() {
        Throwable throwable = null;
        try {
            for (ClassInterceptor classInterceptor : this.classInterceptors) {
                classInterceptor.preTest(this.argumentContext, this.testMethod);
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        if (throwable == null) {
            try {
                TestMethodTestDescriptor.invoke(this.testMethod, this.argumentContext.getClassContext().getTestInstance(), this.invocationArguments);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Assumptions.Failed) {
                    this.markSkipped = true;
                } else if (cause instanceof SkipExecution) {
                    this.markSkipped = true;
                } else {
                    throwable = cause;
                }
            }
            catch (Throwable t) {
                throwable = t;
            }
        }
        try {
            for (ClassInterceptor classInterceptor : this.classInterceptorsReversed) {
                classInterceptor.postTest(this.argumentContext, this.testMethod, throwable);
            }
        }
        catch (Throwable t) {
            TestMethodTestDescriptor.printStackTrace(t);
            this.throwables.add(t);
        }
        return State.AFTER_EACH;
    }

    private State doAfterEach() {
        Throwable throwable = null;
        try {
            for (ClassInterceptor classInterceptor : this.classInterceptors) {
                classInterceptor.preAfterEach(this.argumentContext);
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        if (throwable == null) {
            try {
                for (Method method : this.afterEachMethods) {
                    TestMethodTestDescriptor.invoke(method, this.argumentContext.getClassContext().getTestInstance(), this.invocationArguments);
                }
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof Assumptions.Failed) && !(cause instanceof SkipExecution)) {
                    throwable = cause;
                }
            }
            catch (Throwable t) {
                throwable = t;
            }
        }
        try {
            for (ClassInterceptor classInterceptor : this.classInterceptorsReversed) {
                classInterceptor.postAfterEach(this.argumentContext, throwable);
            }
        }
        catch (Throwable t) {
            TestMethodTestDescriptor.printStackTrace(t);
            this.throwables.add(t);
        }
        return State.END;
    }

    private static enum State {
        START,
        BEFORE_EACH,
        TEST,
        AFTER_EACH,
        END;

    }
}

