/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.interceptor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.verifyica.api.ClassInterceptor;
import org.verifyica.api.Configuration;
import org.verifyica.api.EngineContext;
import org.verifyica.api.Verifyica;
import org.verifyica.engine.common.AnsiColor;
import org.verifyica.engine.common.Precondition;
import org.verifyica.engine.common.StackTracePrinter;
import org.verifyica.engine.exception.EngineException;
import org.verifyica.engine.exception.TestClassDefinitionException;
import org.verifyica.engine.interceptor.DefaultClassInterceptor;
import org.verifyica.engine.interceptor.InterceptorPredicates;
import org.verifyica.engine.logger.Logger;
import org.verifyica.engine.logger.LoggerFactory;
import org.verifyica.engine.resolver.ResolverPredicates;
import org.verifyica.engine.support.ClassSupport;
import org.verifyica.engine.support.HierarchyTraversalMode;
import org.verifyica.engine.support.ListSupport;
import org.verifyica.engine.support.ObjectSupport;
import org.verifyica.engine.support.OrderSupport;

public class ClassInterceptorRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassInterceptorRegistry.class);
    private final Configuration configuration;
    private final ReadWriteLock readWriteLock;
    private final List<ClassInterceptor> classInterceptors;
    private final Map<Class<?>, List<ClassInterceptor>> mappedClassInterceptors;

    public ClassInterceptorRegistry(Configuration configuration) {
        this.configuration = configuration;
        this.readWriteLock = new ReentrantReadWriteLock(true);
        this.classInterceptors = new ArrayList<ClassInterceptor>();
        this.classInterceptors.add(new DefaultClassInterceptor());
        this.mappedClassInterceptors = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initialize(EngineContext engineContext) {
        this.readWriteLock.writeLock().lock();
        try {
            LOGGER.trace("initialize()");
            LOGGER.trace("loading autowired class interceptors");
            ArrayList autowiredClassInterceptors = new ArrayList(ClassSupport.findAllClasses(InterceptorPredicates.AUTOWIRED_CLASS_INTERCEPTOR_CLASS));
            this.filter(autowiredClassInterceptors);
            OrderSupport.orderClasses(autowiredClassInterceptors);
            LOGGER.trace("autowired class interceptor count [%d]", autowiredClassInterceptors.size());
            for (Class clazz : autowiredClassInterceptors) {
                try {
                    LOGGER.trace("loading autowired class interceptor [%s]", clazz.getName());
                    ClassInterceptor classInterceptor = (ClassInterceptor)ObjectSupport.createObject(clazz);
                    classInterceptor.initialize(engineContext);
                    this.classInterceptors.add(classInterceptor);
                    LOGGER.trace("autowired class interceptor [%s] loaded", clazz.getName());
                }
                catch (EngineException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new EngineException(t);
                    return;
                }
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ClassInterceptor> getClassInterceptors(EngineContext engineContext, Class<?> testClass) throws Throwable {
        this.readWriteLock.readLock().lock();
        try {
            ArrayList<ClassInterceptor> classInterceptors = new ArrayList<ClassInterceptor>(this.classInterceptors);
            classInterceptors.addAll(this.getDeclaredClassInterceptor(engineContext, testClass));
            ArrayList<ClassInterceptor> arrayList = classInterceptors;
            return arrayList;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    private synchronized List<ClassInterceptor> getDeclaredClassInterceptor(EngineContext engineContext, Class<?> testClass) throws Throwable {
        List<ClassInterceptor> classInterceptors;
        block13: {
            Object object;
            block15: {
                block14: {
                    classInterceptors = this.mappedClassInterceptors.get(testClass);
                    if (classInterceptors != null) {
                        return classInterceptors;
                    }
                    classInterceptors = new ArrayList<ClassInterceptor>();
                    this.mappedClassInterceptors.put(testClass, classInterceptors);
                    List<Method> classInterceptorSupplierMethods = ClassSupport.findMethods(testClass, ResolverPredicates.CLASS_INTERCEPTOR_SUPPLIER, HierarchyTraversalMode.BOTTOM_UP);
                    ClassInterceptorRegistry.validateSingleMethodPerClass(Verifyica.ClassInterceptorSupplier.class, classInterceptorSupplierMethods);
                    if (classInterceptorSupplierMethods.isEmpty()) break block13;
                    Method classInterceptorSupplierMethod = classInterceptorSupplierMethods.get(0);
                    object = classInterceptorSupplierMethod.invoke(null, new Object[0]);
                    if (object == null) {
                        throw new TestClassDefinitionException(String.format("Null Object supplied by test class [%s] @Verifyica.ClassInterceptorSupplier method", testClass.getName()));
                    }
                    if (!(object instanceof ClassInterceptor)) break block14;
                    ClassInterceptor classInterceptor = (ClassInterceptor)object;
                    classInterceptor.initialize(engineContext);
                    classInterceptors.add(classInterceptor);
                    break block13;
                }
                if (!object.getClass().isArray()) break block15;
                Object[] objects = (Object[])object;
                if (objects.length <= 0) break block13;
                int index = 0;
                for (Object o : objects) {
                    if (!(o instanceof ClassInterceptor)) {
                        throw new TestClassDefinitionException(String.format("Invalid type [%s] supplied by test class [%s] @Verifyica.ClassInterceptorSupplier method at index [%d]", o.getClass().getName(), testClass.getName(), index));
                    }
                    ClassInterceptor classInterceptor = (ClassInterceptor)o;
                    classInterceptor.initialize(engineContext);
                    classInterceptors.add(classInterceptor);
                    ++index;
                }
                break block13;
            }
            if (object instanceof Stream || object instanceof Iterable || object instanceof Iterator || object instanceof Enumeration) {
                Iterator iterator;
                if (object instanceof Enumeration) {
                    iterator = Collections.list((Enumeration)object).iterator();
                } else if (object instanceof Iterator) {
                    iterator = (Iterator)object;
                } else if (object instanceof Stream) {
                    Stream stream = (Stream)object;
                    iterator = stream.iterator();
                } else {
                    Iterable iterable = (Iterable)object;
                    iterator = iterable.iterator();
                }
                while (iterator.hasNext()) {
                    Object o = iterator.next();
                    if (o instanceof ClassInterceptor) {
                        ClassInterceptor classInterceptor = (ClassInterceptor)o;
                        classInterceptor.initialize(engineContext);
                        classInterceptors.add(classInterceptor);
                        continue;
                    }
                    throw new TestClassDefinitionException(String.format("Invalid type [%s] supplied by test class [%s] @Verifyica.ClassInterceptorSupplier method", o.getClass().getName(), testClass.getName()));
                }
            }
        }
        return classInterceptors;
    }

    public void destroy(EngineContext engineContext) {
        for (Map.Entry<Class<?>, List<ClassInterceptor>> entry : this.mappedClassInterceptors.entrySet()) {
            List<ClassInterceptor> classInterceptorsReversed = ListSupport.copyAndReverse(entry.getValue());
            for (ClassInterceptor classInterceptor : classInterceptorsReversed) {
                try {
                    classInterceptor.destroy(engineContext);
                }
                catch (Throwable t) {
                    StackTracePrinter.printStackTrace(t, AnsiColor.TEXT_RED_BOLD, System.err);
                }
            }
        }
        List<ClassInterceptor> classInterceptorsReversed = ListSupport.copyAndReverse(this.classInterceptors);
        for (ClassInterceptor classInterceptor : classInterceptorsReversed) {
            try {
                classInterceptor.destroy(engineContext);
            }
            catch (Throwable t) {
                StackTracePrinter.printStackTrace(t, AnsiColor.TEXT_RED_BOLD, System.err);
            }
        }
    }

    private void filter(List<Class<?>> classes) {
        LinkedHashSet filteredClasses = new LinkedHashSet(classes);
        Optional.ofNullable(this.configuration.getProperties().getProperty("verifyica.engine.autowired.class.interceptors.exclude.regex")).ifPresent(regex -> {
            LOGGER.trace("%s [%s]", "verifyica.engine.autowired.class.interceptors.exclude.regex", regex);
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher("");
            Iterator iterator = filteredClasses.iterator();
            while (iterator.hasNext()) {
                Class clazz = (Class)iterator.next();
                matcher.reset(clazz.getName());
                if (!matcher.find()) continue;
                LOGGER.trace("removing class interceptor [%s]", clazz.getName());
                iterator.remove();
            }
        });
        Optional.ofNullable(this.configuration.getProperties().getProperty("verifyica.engine.autowired.class.interceptors.include.regex")).ifPresent(regex -> {
            LOGGER.trace("%s [%s]", "verifyica.engine.autowired.class.interceptors.include.regex", regex);
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher("");
            for (Class clazz : classes) {
                matcher.reset(clazz.getName());
                if (!matcher.find()) continue;
                LOGGER.trace("adding class interceptor [%s]", clazz.getName());
                filteredClasses.add(clazz);
            }
        });
        classes.clear();
        classes.addAll(filteredClasses);
    }

    private static void validateSingleMethodPerClass(Class<?> annotationClass, List<Method> methods) {
        Precondition.notNull(annotationClass, "annotationClass is null");
        if (methods != null) {
            HashSet classes = new HashSet();
            methods.forEach(method -> {
                if (classes.contains(method.getDeclaringClass())) {
                    String annotationDisplayName = "@Verifyica." + annotationClass.getSimpleName();
                    throw new TestClassDefinitionException(String.format("Test class [%s] contains more than one method annotated with [%s]", method.getDeclaringClass().getName(), annotationDisplayName));
                }
                classes.add(method.getDeclaringClass());
            });
        }
    }
}

