/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.listener;

import java.util.ArrayList;
import java.util.Collection;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.verifyica.engine.common.Precondition;

public class ChainedEngineExecutionListener
implements EngineExecutionListener {
    private final Collection<EngineExecutionListener> engineExecutionListeners = new ArrayList<EngineExecutionListener>();

    public ChainedEngineExecutionListener(EngineExecutionListener engineExecutionListener) {
        Precondition.notNull(engineExecutionListener, "engineExecutionListener is null");
        this.add(engineExecutionListener);
    }

    public ChainedEngineExecutionListener(EngineExecutionListener ... engineExecutionListeners) {
        Precondition.notNull(engineExecutionListeners, "engineExecutionListeners is null");
        Precondition.isTrue(engineExecutionListeners.length > 0, "engineExecutionListeners is empty");
        for (EngineExecutionListener engineExecutionListener : engineExecutionListeners) {
            this.add(engineExecutionListener);
        }
    }

    public ChainedEngineExecutionListener(Collection<EngineExecutionListener> engineExecutionListeners) {
        Precondition.notNull(engineExecutionListeners, "engineExecutionListeners is null");
        Precondition.isFalse(engineExecutionListeners.isEmpty(), "engineExecutionListeners is empty");
        engineExecutionListeners.forEach(this::add);
    }

    public ChainedEngineExecutionListener add(EngineExecutionListener engineExecutionListener) {
        Precondition.notNull(engineExecutionListener, "engineExecutionListener is null");
        this.engineExecutionListeners.add(engineExecutionListener);
        return this;
    }

    public Collection<EngineExecutionListener> getEngineExecutionListeners() {
        return this.engineExecutionListeners;
    }

    public void dynamicTestRegistered(TestDescriptor testDescriptor) {
        this.engineExecutionListeners.forEach(engineExecutionListener -> engineExecutionListener.dynamicTestRegistered(testDescriptor));
    }

    public void executionSkipped(TestDescriptor testDescriptor, String reason) {
        this.engineExecutionListeners.forEach(engineExecutionListener -> engineExecutionListener.executionSkipped(testDescriptor, reason));
    }

    public void executionStarted(TestDescriptor testDescriptor) {
        this.engineExecutionListeners.forEach(engineExecutionListener -> engineExecutionListener.executionStarted(testDescriptor));
    }

    public void executionFinished(TestDescriptor testDescriptor, TestExecutionResult testExecutionResult) {
        this.engineExecutionListeners.forEach(engineExecutionListener -> engineExecutionListener.executionFinished(testDescriptor, testExecutionResult));
    }

    public void reportingEntryPublished(TestDescriptor testDescriptor, ReportEntry entry) {
        this.engineExecutionListeners.forEach(engineExecutionListener -> engineExecutionListener.reportingEntryPublished(testDescriptor, entry));
    }
}

