/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.listener;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.verifyica.engine.VerifyicaTestEngine;
import org.verifyica.engine.common.AnsiColor;
import org.verifyica.engine.common.AnsiColoredString;
import org.verifyica.engine.common.StackTracePrinter;
import org.verifyica.engine.common.Stopwatch;
import org.verifyica.engine.descriptor.ArgumentTestDescriptor;
import org.verifyica.engine.descriptor.ClassTestDescriptor;
import org.verifyica.engine.descriptor.TestMethodTestDescriptor;
import org.verifyica.engine.descriptor.TestableTestDescriptor;
import org.verifyica.engine.support.HumanReadableTimeSupport;

public class SummaryEngineExecutionListener
implements EngineExecutionListener {
    private static final String BANNER = new AnsiColoredString().append(AnsiColor.TEXT_WHITE_BRIGHT).append("Verifyica ").append(VerifyicaTestEngine.staticGetVersion()).append(AnsiColor.NONE).build();
    private static final String SUMMARY_BANNER = BANNER + AnsiColor.TEXT_WHITE_BRIGHT.wrap(" Summary");
    private static final String SEPARATOR = AnsiColor.TEXT_WHITE_BRIGHT.wrap("------------------------------------------------------------------------");
    private static final String INFO = new AnsiColoredString().append(AnsiColor.TEXT_WHITE).append("[").append(AnsiColor.TEXT_BLUE_BOLD).append("INFO").append(AnsiColor.TEXT_WHITE).append("]").append(AnsiColor.NONE).append(" ").build();
    private static final Map<String, String> counterKeyToMessageDisplayStringMap = new HashMap<String, String>();
    private final Map<ClassTestDescriptor, TestExecutionResult> classTestDescriptorTestExecutionResultMap = new ConcurrentHashMap<ClassTestDescriptor, TestExecutionResult>();
    private final Map<ClassTestDescriptor, String> classTestDescriptorSkippedMap = new ConcurrentHashMap<ClassTestDescriptor, String>();
    private final Map<ArgumentTestDescriptor, TestExecutionResult> argumentTestDescriptorTestExecutionResultMap = new ConcurrentHashMap<ArgumentTestDescriptor, TestExecutionResult>();
    private final Map<ArgumentTestDescriptor, String> argumentTestDescriptorSkippedMap = new ConcurrentHashMap<ArgumentTestDescriptor, String>();
    private final Map<TestMethodTestDescriptor, TestExecutionResult> testMethodTestDescriptorTestExecutionResultMap = new ConcurrentHashMap<TestMethodTestDescriptor, TestExecutionResult>();
    private final Map<TestMethodTestDescriptor, String> testMethodTestDescriptorSkippedMap = new ConcurrentHashMap<TestMethodTestDescriptor, String>();
    private final AtomicLong failureCount = new AtomicLong();
    private final Map<String, AtomicLong> counterMap = new ConcurrentHashMap<String, AtomicLong>();
    private final Stopwatch stopwatch = new Stopwatch();

    public void executionStarted(TestDescriptor testDescriptor) {
        if (testDescriptor.isRoot()) {
            this.stopwatch.reset();
        }
    }

    public void executionSkipped(TestDescriptor testDescriptor, String reason) {
        if (testDescriptor instanceof ClassTestDescriptor) {
            this.classTestDescriptorSkippedMap.put((ClassTestDescriptor)testDescriptor, reason);
        } else if (testDescriptor instanceof ArgumentTestDescriptor) {
            this.argumentTestDescriptorSkippedMap.put((ArgumentTestDescriptor)testDescriptor, reason);
        } else if (testDescriptor instanceof TestMethodTestDescriptor) {
            this.testMethodTestDescriptorSkippedMap.put((TestMethodTestDescriptor)testDescriptor, reason != null ? reason : "Skipped");
        }
    }

    public void executionFinished(TestDescriptor testDescriptor, TestExecutionResult testExecutionResult) {
        if (testDescriptor instanceof ClassTestDescriptor) {
            this.classTestDescriptorTestExecutionResultMap.put((ClassTestDescriptor)testDescriptor, testExecutionResult);
        } else if (testDescriptor instanceof ArgumentTestDescriptor) {
            this.argumentTestDescriptorTestExecutionResultMap.put((ArgumentTestDescriptor)testDescriptor, testExecutionResult);
        } else if (testDescriptor instanceof TestMethodTestDescriptor) {
            this.testMethodTestDescriptorTestExecutionResultMap.put((TestMethodTestDescriptor)testDescriptor, testExecutionResult);
        }
        if (testExecutionResult.getStatus() == TestExecutionResult.Status.FAILED) {
            this.failureCount.incrementAndGet();
        }
        if (testDescriptor.isRoot()) {
            this.summary();
        }
    }

    private void summary() {
        try {
            String[] keys;
            String key;
            TestExecutionResult.Status status;
            TestExecutionResult testExecutionResult;
            int i;
            this.stopwatch.stop();
            for (i = 0; i < this.classTestDescriptorSkippedMap.size(); ++i) {
                String string = "test.class.count";
                this.counterMap.computeIfAbsent(string, k -> new AtomicLong()).incrementAndGet();
                this.counterMap.computeIfAbsent(string + ".skipped", k -> new AtomicLong()).incrementAndGet();
            }
            for (i = 0; i < this.argumentTestDescriptorSkippedMap.size(); ++i) {
                String string = "test.argument.count";
                this.counterMap.computeIfAbsent(string, k -> new AtomicLong()).incrementAndGet();
                this.counterMap.computeIfAbsent(string + ".skipped", k -> new AtomicLong()).incrementAndGet();
            }
            for (i = 0; i < this.testMethodTestDescriptorSkippedMap.size(); ++i) {
                String string = "test.method.count";
                this.counterMap.computeIfAbsent(string, k -> new AtomicLong()).incrementAndGet();
                this.counterMap.computeIfAbsent(string + ".skipped", k -> new AtomicLong()).incrementAndGet();
            }
            for (Map.Entry<ClassTestDescriptor, TestExecutionResult> entry : this.classTestDescriptorTestExecutionResultMap.entrySet()) {
                testExecutionResult = entry.getValue();
                status = testExecutionResult.getStatus();
                key = "test.class.count";
                this.counterMap.computeIfAbsent(key, k -> new AtomicLong()).incrementAndGet();
                switch (status) {
                    case SUCCESSFUL: {
                        this.counterMap.computeIfAbsent(key + ".successful", k -> new AtomicLong()).incrementAndGet();
                        break;
                    }
                    case FAILED: {
                        this.counterMap.computeIfAbsent(key + ".failed", k -> new AtomicLong()).incrementAndGet();
                        break;
                    }
                    case ABORTED: {
                        this.counterMap.computeIfAbsent(key + ".skipped", k -> new AtomicLong()).incrementAndGet();
                        break;
                    }
                }
            }
            for (Map.Entry<TestableTestDescriptor, TestExecutionResult> entry : this.argumentTestDescriptorTestExecutionResultMap.entrySet()) {
                testExecutionResult = entry.getValue();
                status = testExecutionResult.getStatus();
                key = "test.argument.count";
                this.counterMap.computeIfAbsent(key, k -> new AtomicLong()).incrementAndGet();
                switch (status) {
                    case SUCCESSFUL: {
                        this.counterMap.computeIfAbsent(key + ".successful", k -> new AtomicLong()).incrementAndGet();
                        break;
                    }
                    case FAILED: {
                        this.counterMap.computeIfAbsent(key + ".failed", k -> new AtomicLong()).incrementAndGet();
                        break;
                    }
                    case ABORTED: {
                        this.counterMap.computeIfAbsent(key + ".skipped", k -> new AtomicLong()).incrementAndGet();
                        break;
                    }
                }
            }
            for (Map.Entry<TestableTestDescriptor, TestExecutionResult> entry : this.testMethodTestDescriptorTestExecutionResultMap.entrySet()) {
                testExecutionResult = entry.getValue();
                status = testExecutionResult.getStatus();
                key = "test.method.count";
                this.counterMap.computeIfAbsent(key, k -> new AtomicLong()).incrementAndGet();
                switch (status) {
                    case SUCCESSFUL: {
                        this.counterMap.computeIfAbsent(key + ".successful", k -> new AtomicLong()).incrementAndGet();
                        break;
                    }
                    case FAILED: {
                        this.counterMap.computeIfAbsent(key + ".failed", k -> new AtomicLong()).incrementAndGet();
                        break;
                    }
                    case ABORTED: {
                        this.counterMap.computeIfAbsent(key + ".skipped", k -> new AtomicLong()).incrementAndGet();
                        break;
                    }
                }
            }
            SummaryEngineExecutionListener.println(INFO + SEPARATOR);
            SummaryEngineExecutionListener.println(INFO + SUMMARY_BANNER);
            SummaryEngineExecutionListener.println(INFO + SEPARATOR);
            int countPad = SummaryEngineExecutionListener.getPad(this.counterMap.entrySet().stream().filter(mapEntry -> ((String)mapEntry.getKey()).endsWith(".count")).map(Map.Entry::getValue).collect(Collectors.toList()));
            int n = SummaryEngineExecutionListener.getPad(this.counterMap.entrySet().stream().filter(mapEntry -> ((String)mapEntry.getKey()).endsWith(".successful")).map(Map.Entry::getValue).collect(Collectors.toList()));
            int failedPad = SummaryEngineExecutionListener.getPad(this.counterMap.entrySet().stream().filter(mapEntry -> ((String)mapEntry.getKey()).endsWith(".failed")).map(Map.Entry::getValue).collect(Collectors.toList()));
            int skipPad = SummaryEngineExecutionListener.getPad(this.counterMap.entrySet().stream().filter(mapEntry -> ((String)mapEntry.getKey()).endsWith(".skipped")).map(Map.Entry::getValue).collect(Collectors.toList()));
            for (String key3 : keys = new String[]{"test.class", "test.argument", "test.method"}) {
                String[] subKeys;
                StringBuilder stringBuilder = new StringBuilder();
                key3 = key3 + ".count";
                stringBuilder.append(INFO).append(AnsiColor.TEXT_WHITE_BRIGHT.wrap(counterKeyToMessageDisplayStringMap.get(key3))).append(": ").append(AnsiColor.TEXT_WHITE_BRIGHT.wrap(SummaryEngineExecutionListener.pad(this.counterMap.computeIfAbsent(key3, k -> new AtomicLong()).get(), countPad)));
                for (String subKey : subKeys = new String[]{key3 + ".successful", key3 + ".failed", key3 + ".skipped"}) {
                    String countDisplayString;
                    String messageDisplayString = counterKeyToMessageDisplayStringMap.get(subKey);
                    long count = this.counterMap.computeIfAbsent(subKey, k -> new AtomicLong()).get();
                    if (subKey.endsWith(".successful")) {
                        messageDisplayString = AnsiColor.TEXT_GREEN_BOLD_BRIGHT.wrap(messageDisplayString);
                        countDisplayString = AnsiColor.TEXT_GREEN_BOLD_BRIGHT.wrap(SummaryEngineExecutionListener.pad(count, n));
                    } else if (subKey.endsWith(".failed")) {
                        messageDisplayString = AnsiColor.TEXT_RED_BOLD_BRIGHT.wrap(messageDisplayString);
                        countDisplayString = AnsiColor.TEXT_RED_BOLD_BRIGHT.wrap(SummaryEngineExecutionListener.pad(count, failedPad));
                    } else if (subKey.endsWith(".skipped")) {
                        messageDisplayString = AnsiColor.TEXT_YELLOW_BOLD_BRIGHT.wrap(messageDisplayString);
                        countDisplayString = AnsiColor.TEXT_YELLOW_BOLD_BRIGHT.wrap(SummaryEngineExecutionListener.pad(count, skipPad));
                    } else {
                        messageDisplayString = AnsiColor.TEXT_WHITE_BOLD.wrap(messageDisplayString);
                        countDisplayString = AnsiColor.TEXT_WHITE_BOLD.wrap(SummaryEngineExecutionListener.pad(count, skipPad));
                    }
                    if (count == 0L) {
                        messageDisplayString = AnsiColor.stripAnsiEscapeSequences(messageDisplayString);
                        countDisplayString = AnsiColor.stripAnsiEscapeSequences(countDisplayString);
                        messageDisplayString = AnsiColor.TEXT_WHITE_BRIGHT.wrap(messageDisplayString);
                        countDisplayString = AnsiColor.TEXT_WHITE_BRIGHT.wrap(countDisplayString);
                    }
                    stringBuilder.append(" ").append(messageDisplayString).append(AnsiColor.TEXT_WHITE_BOLD).append(" : ").append(countDisplayString);
                }
                SummaryEngineExecutionListener.println(stringBuilder);
            }
            SummaryEngineExecutionListener.println(INFO + SEPARATOR);
            String message = this.failureCount.get() > 0L ? AnsiColor.TEXT_RED_BOLD_BRIGHT.wrap("TESTS FAILED") : AnsiColor.TEXT_GREEN_BOLD_BRIGHT.wrap("TESTS PASSED");
            SummaryEngineExecutionListener.println(INFO + message);
            SummaryEngineExecutionListener.println(INFO + SEPARATOR);
            Duration elapsedTime = this.stopwatch.elapsedTime();
            SummaryEngineExecutionListener.println(new AnsiColoredString().append(INFO).append(AnsiColor.TEXT_WHITE_BRIGHT).append("Total time  : ").append(HumanReadableTimeSupport.toHumanReadable(elapsedTime.toNanos(), HumanReadableTimeSupport.Format.SHORT)).append(" (").append((double)elapsedTime.toNanos() / 1000000.0).append(" ms)").append(AnsiColor.NONE));
            SummaryEngineExecutionListener.println(new AnsiColoredString().append(INFO).append(AnsiColor.TEXT_WHITE_BRIGHT).append("Finished at : ").append(HumanReadableTimeSupport.now()).append(AnsiColor.NONE));
            if (this.failureCount.get() == 0L) {
                SummaryEngineExecutionListener.println(INFO + SEPARATOR);
            }
        }
        catch (Throwable t) {
            StackTracePrinter.printStackTrace(t, AnsiColor.TEXT_RED_BOLD, System.err);
        }
    }

    private static void println(Object object) {
        System.out.println(object);
    }

    private static int getPad(List<AtomicLong> atomicLongs) {
        int pad = 0;
        for (AtomicLong atomicLong : atomicLongs) {
            pad = Math.max(pad, String.valueOf(atomicLong.get()).length());
        }
        return pad;
    }

    private static String pad(long value, long width) {
        String string = String.valueOf(value);
        StringBuilder stringBuilder = new StringBuilder();
        while ((long)(stringBuilder.length() + string.length()) < width) {
            stringBuilder.append(" ");
        }
        return stringBuilder.append(string).toString();
    }

    static {
        counterKeyToMessageDisplayStringMap.put("test.class.count", "Test classes   ");
        counterKeyToMessageDisplayStringMap.put("test.class.count.successful", "Passed");
        counterKeyToMessageDisplayStringMap.put("test.class.count.failed", "Failed");
        counterKeyToMessageDisplayStringMap.put("test.class.count.skipped", "Skipped");
        counterKeyToMessageDisplayStringMap.put("test.argument.count", "Test arguments ");
        counterKeyToMessageDisplayStringMap.put("test.argument.count.successful", "Passed");
        counterKeyToMessageDisplayStringMap.put("test.argument.count.failed", "Failed");
        counterKeyToMessageDisplayStringMap.put("test.argument.count.skipped", "Skipped");
        counterKeyToMessageDisplayStringMap.put("test.method.count", "Test methods   ");
        counterKeyToMessageDisplayStringMap.put("test.method.count.successful", "Passed");
        counterKeyToMessageDisplayStringMap.put("test.method.count.failed", "Failed");
        counterKeyToMessageDisplayStringMap.put("test.method.count.skipped", "Skipped");
    }
}

