/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.resolver;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.Predicate;
import org.verifyica.api.Verifyica;
import org.verifyica.engine.support.ClassSupport;
import org.verifyica.engine.support.HierarchyTraversalMode;

public class ResolverPredicates {
    public static final Predicate<Method> CLASS_INTERCEPTOR_SUPPLIER = method -> {
        int modifiers = method.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && method.getParameterCount() == 0 && !method.getReturnType().equals(Void.TYPE) && method.isAnnotationPresent(Verifyica.ClassInterceptorSupplier.class);
    };
    public static final Predicate<Method> ARGUMENT_SUPPLIER_METHOD = method -> {
        int modifiers = method.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && method.getParameterCount() == 0 && !method.getReturnType().equals(Void.TYPE) && method.isAnnotationPresent(Verifyica.ArgumentSupplier.class);
    };
    public static final Predicate<Method> TEST_METHOD = method -> {
        int modifiers = method.getModifiers();
        return !Modifier.isAbstract(modifiers) && Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && method.getReturnType().equals(Void.TYPE) && method.isAnnotationPresent(Verifyica.Test.class);
    };
    public static final Predicate<Class<?>> TEST_CLASS = clazz -> {
        int modifiers = clazz.getModifiers();
        return !Modifier.isAbstract(modifiers) && !clazz.isAnnotationPresent(Verifyica.Disabled.class) && ResolverPredicates.hasDefaultConstructor(clazz) && !ClassSupport.findMethods(clazz, ARGUMENT_SUPPLIER_METHOD, HierarchyTraversalMode.BOTTOM_UP).isEmpty() && !ClassSupport.findMethods(clazz, TEST_METHOD, HierarchyTraversalMode.TOP_DOWN).isEmpty();
    };
    public static final Predicate<Method> PREPARE_METHOD = method -> {
        int modifiers = method.getModifiers();
        return !Modifier.isAbstract(modifiers) && Modifier.isPublic(modifiers) && method.getReturnType().equals(Void.TYPE) && !method.isAnnotationPresent(Verifyica.Disabled.class) && method.isAnnotationPresent(Verifyica.Prepare.class);
    };
    public static final Predicate<Method> BEFORE_ALL_METHOD = method -> {
        int modifiers = method.getModifiers();
        return !Modifier.isAbstract(modifiers) && Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && method.getReturnType().equals(Void.TYPE) && !method.isAnnotationPresent(Verifyica.Disabled.class) && method.isAnnotationPresent(Verifyica.BeforeAll.class);
    };
    public static final Predicate<Method> BEFORE_EACH_METHOD = method -> {
        int modifiers = method.getModifiers();
        return !Modifier.isAbstract(modifiers) && Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && method.getReturnType().equals(Void.TYPE) && !method.isAnnotationPresent(Verifyica.Disabled.class) && method.isAnnotationPresent(Verifyica.BeforeEach.class);
    };
    public static final Predicate<Method> AFTER_EACH_METHOD = method -> {
        int modifiers = method.getModifiers();
        return !Modifier.isAbstract(modifiers) && Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && method.getReturnType().equals(Void.TYPE) && !method.isAnnotationPresent(Verifyica.Disabled.class) && method.isAnnotationPresent(Verifyica.AfterEach.class);
    };
    public static final Predicate<Method> AFTER_ALL_METHOD = method -> {
        int modifiers = method.getModifiers();
        return !Modifier.isAbstract(modifiers) && Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && method.getReturnType().equals(Void.TYPE) && !method.isAnnotationPresent(Verifyica.Disabled.class) && method.isAnnotationPresent(Verifyica.AfterAll.class);
    };
    public static final Predicate<Method> CONCLUDE_METHOD = method -> {
        int modifiers = method.getModifiers();
        return !Modifier.isAbstract(modifiers) && Modifier.isPublic(modifiers) && method.getReturnType().equals(Void.TYPE) && !method.isAnnotationPresent(Verifyica.Disabled.class) && method.isAnnotationPresent(Verifyica.Conclude.class);
    };

    private ResolverPredicates() {
    }

    private static boolean hasDefaultConstructor(Class<?> clazz) {
        try {
            clazz.getDeclaredConstructor(new Class[0]);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }
}

