/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.support;

import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.ExecutorTool;
import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.SemaphoreExecutor;
import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.ThreadTool;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.verifyica.engine.common.NewPlatformThreadExecutorService;
import org.verifyica.engine.common.Precondition;
import org.verifyica.engine.configuration.ConcreteConfiguration;
import org.verifyica.engine.logger.Logger;
import org.verifyica.engine.logger.LoggerFactory;

public class ExecutorSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutorSupport.class);
    private static final String PLATFORM = "platform";
    private static final String EPHEMERAL = "ephemeral";

    private ExecutorSupport() {
    }

    public static ExecutorService newExecutorService(int parallelism) {
        ExecutorService executorService;
        Precondition.isTrue(parallelism > 0, "parallelism is less than 1");
        LOGGER.trace("newExecutorService() parallelism [%d]", parallelism);
        boolean usePlatformThreads = PLATFORM.equals(ConcreteConfiguration.getInstance().getProperties().getProperty("verifyica.engine.threads"));
        if (!usePlatformThreads && ThreadTool.hasVirtualThreads()) {
            LOGGER.trace("using virtual threads");
            executorService = new SemaphoreExecutor(ExecutorTool.newVirtualThreadPerTaskExecutor(), new Semaphore(parallelism, true));
        } else if (EPHEMERAL.equals(ConcreteConfiguration.getInstance().getProperties().getProperty("verifyica.engine.threads.platform"))) {
            LOGGER.trace("using ephemeral platform threads");
            executorService = new SemaphoreExecutor((ExecutorService)new NewPlatformThreadExecutorService(), new Semaphore(parallelism, true));
        } else {
            LOGGER.trace("using platform thread pool");
            executorService = new ThreadPoolExecutor(parallelism, parallelism, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(parallelism * 10), new BlockingRejectedExecutionHandler());
        }
        return executorService;
    }

    public static void waitForAllFutures(Collection<Future<?>> futures, ExecutorService executorService) {
        Precondition.notNull(futures, "futures is null");
        Precondition.notNull(executorService, "executorService is null");
        LOGGER.trace("waitForAllFutures() futures [%d]", futures.size());
        ExecutorCompletionService<Object> completionService = new ExecutorCompletionService<Object>(executorService);
        HashMap futureMap = new HashMap();
        for (Future<?> future : futures) {
            futureMap.put(completionService.submit(future::get), future);
        }
        for (int i = 0; i < futures.size(); ++i) {
            try {
                Future completedFuture = completionService.take();
                futureMap.get(completedFuture);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                System.err.printf("Error waiting for future [%s]%n", e.getMessage());
            }
        }
    }

    public static void shutdownAndAwaitTermination(ExecutorService executorService) {
        Precondition.notNull(executorService, "executorService is null");
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                executorService.shutdownNow();
                if (!executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                    LOGGER.error("ExecutorService did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private static class BlockingRejectedExecutionHandler
    implements RejectedExecutionHandler {
        private static final Logger LOGGER = LoggerFactory.getLogger(BlockingRejectedExecutionHandler.class);

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
            Precondition.notNull(runnable, "runnable is null");
            Precondition.notNull(executor, "executor is null");
            if (!executor.isShutdown()) {
                try {
                    executor.getQueue().put(runnable);
                }
                catch (InterruptedException e) {
                    LOGGER.error("Runnable discarded!!!");
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

