/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.support;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.verifyica.engine.common.Precondition;

public final class HumanReadableTimeSupport {
    private HumanReadableTimeSupport() {
    }

    public static String toHumanReadable(long nanoseconds) {
        return HumanReadableTimeSupport.toHumanReadable(nanoseconds, Format.LONG);
    }

    public static String toHumanReadable(long nanoseconds, Format format) {
        boolean useShortFormat;
        Precondition.notNull((Object)format, "format is null");
        long nanosecondsPositive = nanoseconds > 0L ? nanoseconds : -nanoseconds;
        long millisecondsDuration = (long)((double)nanosecondsPositive / 1000000.0);
        long hours = TimeUnit.MILLISECONDS.toHours(millisecondsDuration);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millisecondsDuration) - hours * 60L;
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millisecondsDuration) - (hours * 60L * 60L + minutes * 60L);
        long milliseconds = millisecondsDuration - (hours * 60L * 60L * 1000L + minutes * 60L * 1000L + seconds * 1000L);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(hours);
        boolean bl = useShortFormat = format == Format.SHORT;
        if (useShortFormat) {
            stringBuilder.append(" h");
        } else {
            stringBuilder.append(" hour");
            if (hours != 1L) {
                stringBuilder.append("s");
            }
        }
        stringBuilder.append(", ");
        stringBuilder.append(minutes);
        if (useShortFormat) {
            stringBuilder.append(" m");
        } else {
            stringBuilder.append(" minute");
            if (minutes != 1L) {
                stringBuilder.append("s");
            }
        }
        stringBuilder.append(", ");
        stringBuilder.append(seconds);
        if (useShortFormat) {
            stringBuilder.append(" s");
        } else {
            stringBuilder.append(" second");
            if (seconds != 1L) {
                stringBuilder.append("s");
            }
        }
        stringBuilder.append(", ");
        stringBuilder.append(milliseconds);
        stringBuilder.append(" ms");
        String result = stringBuilder.toString();
        if (result.startsWith("0 h, ")) {
            result = result.substring("0 h, ".length());
        }
        if (result.startsWith("0 hours, ")) {
            result = result.substring("0 hours, ".length());
        }
        if (result.startsWith("0 m, ")) {
            result = result.substring("0 m, ".length());
        }
        if (result.startsWith("0 minutes, ")) {
            result = result.substring("0 minutes, ".length());
        }
        if (result.startsWith("0 s, ")) {
            result = result.substring("0 s, ".length());
        }
        if (result.startsWith("0 seconds, ")) {
            result = result.substring("0 seconds, ".length());
        }
        return result;
    }

    public static String now() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX", Locale.ENGLISH);
        return simpleDateFormat.format(new Date());
    }

    public static String toTimingUnit(long nanoseconds, String timingUnit) {
        String workingUnit;
        switch (workingUnit = timingUnit == null || timingUnit.trim().equalsIgnoreCase("") ? "milliseconds" : timingUnit.trim().toLowerCase(Locale.ENGLISH)) {
            case "nanoseconds": {
                return nanoseconds + " ns";
            }
            case "microseconds": {
                return (double)nanoseconds / 1000.0 + " \u03bcs";
            }
            case "seconds": {
                return (double)nanoseconds / 1.0E9 + " s";
            }
            case "minutes": {
                return (double)nanoseconds / 1.0E12 + " m";
            }
            case "adaptive": {
                if ((double)nanoseconds >= 1.0E12) {
                    return (double)nanoseconds / 1.0E12 + " m";
                }
                if ((double)nanoseconds >= 1.0E9) {
                    return (double)nanoseconds / 1.0E9 + " s";
                }
                if ((double)nanoseconds >= 1000000.0) {
                    return (double)nanoseconds / 1000000.0 + " ms";
                }
                if ((double)nanoseconds >= 1000.0) {
                    return (double)nanoseconds / 1000.0 + " \u03bcs";
                }
                return nanoseconds + " ns";
            }
        }
        return (double)nanoseconds / 1000000.0 + " ms";
    }

    public static enum Format {
        LONG,
        SHORT;

    }
}

