/*
 * Decompiled with CFR 0.152.
 */
package 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge;

import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.ThreadBuilders21;
import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.ThreadCustomizer;
import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.ThreadProvider;
import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.ThreadProviderConfig;
import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.ThreadTool;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

final class ThreadProvider21
implements ThreadProvider {
    private final ThreadProviderConfig config = new ThreadProviderConfig();

    ThreadProvider21() {
    }

    @Override
    public ThreadProviderConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean hasVirtualThreads() {
        return true;
    }

    @Override
    public boolean isVirtual(Thread thread) {
        return thread.isVirtual();
    }

    @Override
    public Thread startVirtualThread(Runnable task) {
        Thread thread = this.unstartedVirtualThread(task);
        thread.start();
        return thread;
    }

    @Override
    public Thread unstartedVirtualThread(Runnable task) {
        return this.unstartedVirtualThread(task, this.config.getThreadCustomizer());
    }

    private Thread unstartedVirtualThread(Runnable task, ThreadCustomizer threadCustomizer) {
        Thread thread = Thread.ofVirtual().unstarted(task);
        threadCustomizer.customize(thread);
        return thread;
    }

    @Override
    public ExecutorService newThreadPerTaskExecutor(ThreadFactory threadFactory) {
        return Executors.newThreadPerTaskExecutor(this.config.getThreadCustomizer().asThreadFactory(threadFactory));
    }

    @Override
    public ExecutorService newVirtualThreadPerTaskExecutor() {
        ThreadFactory factory = Thread.ofVirtual().factory();
        return this.newThreadPerTaskExecutor(factory);
    }

    @Override
    public ExecutorService newVirtualThreadPerTaskExecutor(ThreadCustomizer threadCustomizer) {
        return this.newThreadPerTaskExecutor(runnable -> this.unstartedVirtualThread(runnable, threadCustomizer));
    }

    @Override
    public ThreadTool.Builder.OfPlatform ofPlatform() {
        return new ThreadBuilders21.PlatformThreadBuilder();
    }

    @Override
    public ThreadTool.Builder.OfVirtual ofVirtual() {
        return new ThreadBuilders21.VirtualThreadBuilder();
    }
}

