/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.common;

import java.util.Objects;
import org.verifyica.engine.common.AnsiColor;

public class AnsiColoredString {
    private final StringBuilder stringBuilder = new StringBuilder();
    private AnsiColor lastAnsiColor;

    public AnsiColoredString() {
        this((AnsiColor)null);
    }

    public AnsiColoredString(String string) {
        this.stringBuilder.append(string);
        this.lastAnsiColor = null;
    }

    public AnsiColoredString(AnsiColor ansiColor) {
        if (ansiColor != null) {
            this.stringBuilder.append(ansiColor);
            this.lastAnsiColor = ansiColor;
        }
    }

    public AnsiColoredString append(boolean b) {
        this.stringBuilder.append(b);
        return this;
    }

    public AnsiColoredString append(short s) {
        this.stringBuilder.append(s);
        return this;
    }

    public AnsiColoredString append(char c) {
        this.stringBuilder.append(c);
        return this;
    }

    public AnsiColoredString append(char[] chars) {
        this.stringBuilder.append(chars);
        return this;
    }

    public AnsiColoredString append(char[] chars, int offset, int length) {
        this.stringBuilder.append(chars, offset, length);
        return this;
    }

    public AnsiColoredString append(int i) {
        this.stringBuilder.append(i);
        return this;
    }

    public AnsiColoredString append(long l) {
        this.stringBuilder.append(l);
        return this;
    }

    public AnsiColoredString append(float f) {
        this.stringBuilder.append(f);
        return this;
    }

    public AnsiColoredString append(double d) {
        this.stringBuilder.append(d);
        return this;
    }

    public AnsiColoredString append(String s) {
        this.stringBuilder.append(s);
        return this;
    }

    public AnsiColoredString append(Object o) {
        this.stringBuilder.append(o);
        return this;
    }

    public AnsiColoredString append(StringBuffer sb) {
        this.stringBuilder.append(sb);
        return this;
    }

    public AnsiColoredString append(CharSequence cs) {
        this.stringBuilder.append(cs);
        return this;
    }

    public AnsiColoredString append(AnsiColor ansiColor) {
        if (ansiColor == null || ansiColor.equals(AnsiColor.NONE) && this.stringBuilder.length() == 0) {
            return this;
        }
        if (!ansiColor.equals(this.lastAnsiColor)) {
            this.stringBuilder.append(ansiColor);
            this.lastAnsiColor = ansiColor;
        }
        return this;
    }

    public int length() {
        return this.stringBuilder.length();
    }

    public boolean isAnsiColorSupported() {
        return AnsiColor.isSupported();
    }

    public String build() {
        return this.stringBuilder.toString();
    }

    public String toString() {
        return this.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnsiColoredString that = (AnsiColoredString)o;
        return Objects.equals(this.stringBuilder.toString(), that.stringBuilder.toString()) && Objects.equals(this.lastAnsiColor, that.lastAnsiColor);
    }

    public int hashCode() {
        return Objects.hash(this.stringBuilder, this.lastAnsiColor);
    }
}

