/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.descriptor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.verifyica.api.Argument;
import org.verifyica.api.ArgumentContext;
import org.verifyica.api.Assumptions;
import org.verifyica.api.ClassContext;
import org.verifyica.api.ClassInterceptor;
import org.verifyica.api.Execution;
import org.verifyica.api.ExtendedMap;
import org.verifyica.api.SkipExecution;
import org.verifyica.engine.context.ConcreteArgumentContext;
import org.verifyica.engine.descriptor.TestDescriptorStatus;
import org.verifyica.engine.descriptor.TestableTestDescriptor;
import org.verifyica.engine.inject.Inject;
import org.verifyica.engine.inject.Injector;
import org.verifyica.engine.inject.Named;
import org.verifyica.engine.logger.Logger;
import org.verifyica.engine.logger.LoggerFactory;

public class ArgumentTestDescriptor
extends TestableTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArgumentTestDescriptor.class);
    private final int argumentIndex;
    private final Argument<?> argument;
    private final List<Method> beforeAllMethods;
    private final List<Method> afterAllMethods;
    private final List<Object> invocationArguments;
    private final List<Throwable> throwables;
    @Inject
    @Named(value="engineExecutionListener")
    private EngineExecutionListener engineExecutionListener;
    @Inject
    @Named(value="classInterceptors")
    private List<ClassInterceptor> classInterceptors;
    @Inject
    @Named(value="classInterceptorsReversed")
    private List<ClassInterceptor> classInterceptorsReversed;
    @Inject
    @Named(value="classContext")
    private ClassContext classContext;
    private ArgumentContext argumentContext;
    private boolean markSkipped;

    public ArgumentTestDescriptor(UniqueId uniqueId, String displayName, int argumentIndex, Argument<?> argument, List<Method> beforeAllMethods, List<Method> afterAllMethods) {
        super(uniqueId, displayName);
        this.argumentIndex = argumentIndex;
        this.argument = argument;
        this.beforeAllMethods = beforeAllMethods;
        this.afterAllMethods = afterAllMethods;
        this.invocationArguments = new ArrayList<Object>();
        this.throwables = new ArrayList<Throwable>();
    }

    public Argument<?> getArgument() {
        return this.argument;
    }

    @Override
    public ArgumentTestDescriptor test() {
        try {
            this.argumentContext = new ConcreteArgumentContext(this.classContext, this.argumentIndex, this.argument);
            this.invocationArguments.add(this.argumentContext.getTestArgument().getPayload());
            this.invocationArguments.add(this.argumentContext.getTestArgument());
            this.invocationArguments.add(this.argumentContext);
            for (TestDescriptor testDescriptor : this.getChildren()) {
                Injector.inject("engineExecutionListener", (Object)this.engineExecutionListener, (Object)testDescriptor);
                Injector.inject("classInterceptors", this.classInterceptors, (Object)testDescriptor);
                Injector.inject("classInterceptorsReversed", this.classInterceptorsReversed, (Object)testDescriptor);
                Injector.inject("argumentContext", (Object)this.argumentContext, (Object)testDescriptor);
            }
            this.engineExecutionListener.executionStarted((TestDescriptor)this);
            State state = State.START;
            block13: while (state != State.END) {
                LOGGER.trace("testDescriptor [%s] state [%s]", new Object[]{this, state});
                switch (state.ordinal()) {
                    case 0: {
                        state = State.BEFORE_ALL;
                        continue block13;
                    }
                    case 1: {
                        state = this.doBeforeAll();
                        continue block13;
                    }
                    case 2: {
                        state = this.doTestDependent();
                        continue block13;
                    }
                    case 3: {
                        state = this.doTestIndependent();
                        continue block13;
                    }
                    case 4: {
                        state = this.doSkipChildren();
                        continue block13;
                    }
                    case 5: {
                        state = this.doAfterAll();
                        continue block13;
                    }
                    case 6: {
                        state = this.doClose();
                        continue block13;
                    }
                    case 7: {
                        state = this.doCleanup();
                        continue block13;
                    }
                }
                throw new IllegalStateException(String.format("Invalid State [%s]", new Object[]{state}));
            }
            if (this.markSkipped) {
                this.setTestDescriptorStatus(TestDescriptorStatus.skipped());
                this.engineExecutionListener.executionSkipped((TestDescriptor)this, "Skipped");
            } else {
                TestDescriptorStatus testDescriptorStatus;
                TestExecutionResult testExecutionResult;
                if (this.throwables.isEmpty()) {
                    testExecutionResult = TestExecutionResult.successful();
                    testDescriptorStatus = TestDescriptorStatus.passed();
                } else {
                    testExecutionResult = TestExecutionResult.failed((Throwable)this.throwables.get(0));
                    testDescriptorStatus = TestDescriptorStatus.failed(this.throwables.get(0));
                }
                this.setTestDescriptorStatus(testDescriptorStatus);
                this.engineExecutionListener.executionFinished((TestDescriptor)this, testExecutionResult);
            }
        }
        catch (Throwable t) {
            ArgumentTestDescriptor.printStackTrace(t);
            this.setTestDescriptorStatus(TestDescriptorStatus.failed(t));
            this.engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)t));
        }
        return this;
    }

    @Override
    public void skip() {
        this.engineExecutionListener.executionStarted((TestDescriptor)this);
        this.getChildren().stream().map(TESTABLE_TEST_DESCRIPTOR_MAPPER).forEach(testableTestDescriptor -> {
            Injector.inject("engineExecutionListener", (Object)this.engineExecutionListener, testableTestDescriptor);
            Injector.inject("classInterceptors", this.classInterceptors, testableTestDescriptor);
            Injector.inject("classInterceptorsReversed", this.classInterceptorsReversed, testableTestDescriptor);
            Injector.inject("classContext", (Object)this.classContext, testableTestDescriptor);
            testableTestDescriptor.skip();
        });
        this.engineExecutionListener.executionSkipped((TestDescriptor)this, "Skipped");
        this.setTestDescriptorStatus(TestDescriptorStatus.skipped());
    }

    private State doBeforeAll() {
        Throwable throwable = null;
        try {
            for (ClassInterceptor classInterceptor : this.classInterceptors) {
                classInterceptor.preBeforeAll(this.argumentContext);
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        if (throwable == null) {
            try {
                for (Method method : this.beforeAllMethods) {
                    ArgumentTestDescriptor.invoke(method, this.classContext.getTestInstance(), this.invocationArguments);
                }
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Assumptions.Failed || cause instanceof SkipExecution || cause instanceof Execution.ExecutionSkippedException) {
                    this.markSkipped = true;
                } else {
                    throwable = cause;
                }
            }
            catch (Throwable t) {
                throwable = t;
            }
        }
        try {
            for (ClassInterceptor classInterceptor : this.classInterceptorsReversed) {
                classInterceptor.postBeforeAll(this.argumentContext, throwable);
            }
        }
        catch (Throwable t) {
            throwable = t;
            ArgumentTestDescriptor.printStackTrace(t);
            this.throwables.add(t);
        }
        if (this.markSkipped) {
            return State.SKIP;
        }
        if (throwable == null) {
            return State.TEST_DEPENDENT;
        }
        return State.AFTER_ALL;
    }

    private State doTestDependent() {
        TestableTestDescriptor testableTestDescriptor;
        Iterator testableTestDescriptorIterator = this.getChildren().stream().map(TESTABLE_TEST_DESCRIPTOR_MAPPER).iterator();
        while (testableTestDescriptorIterator.hasNext() && !(testableTestDescriptor = (TestableTestDescriptor)((Object)testableTestDescriptorIterator.next())).test().getTestDescriptorStatus().isFailure()) {
        }
        while (testableTestDescriptorIterator.hasNext()) {
            testableTestDescriptor = (TestableTestDescriptor)((Object)testableTestDescriptorIterator.next());
            testableTestDescriptor.skip();
        }
        return State.AFTER_ALL;
    }

    private State doTestIndependent() {
        Iterator testableTestDescriptorIterator = this.getChildren().stream().map(TESTABLE_TEST_DESCRIPTOR_MAPPER).iterator();
        while (testableTestDescriptorIterator.hasNext()) {
            TestableTestDescriptor testableTestDescriptor = (TestableTestDescriptor)((Object)testableTestDescriptorIterator.next());
            testableTestDescriptor.test();
        }
        return State.AFTER_ALL;
    }

    private State doSkipChildren() {
        this.getChildren().stream().map(TESTABLE_TEST_DESCRIPTOR_MAPPER).forEach(testableTestDescriptor -> {
            Injector.inject("engineExecutionListener", (Object)this.engineExecutionListener, testableTestDescriptor);
            Injector.inject("classInterceptors", this.classInterceptors, testableTestDescriptor);
            Injector.inject("classInterceptorsReversed", this.classInterceptorsReversed, testableTestDescriptor);
            Injector.inject("classContext", (Object)this.classContext, testableTestDescriptor);
            testableTestDescriptor.skip();
        });
        return State.AFTER_ALL;
    }

    private State doAfterAll() {
        Throwable throwable = null;
        try {
            for (ClassInterceptor classInterceptor : this.classInterceptors) {
                classInterceptor.preAfterAll(this.argumentContext);
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        if (throwable == null) {
            try {
                for (Method method : this.afterAllMethods) {
                    ArgumentTestDescriptor.invoke(method, this.classContext.getTestInstance(), this.invocationArguments);
                }
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof Assumptions.Failed || cause instanceof SkipExecution || cause instanceof Execution.ExecutionSkippedException)) {
                    throwable = cause;
                }
            }
            catch (Throwable t) {
                throwable = t;
            }
        }
        try {
            for (ClassInterceptor classInterceptor : this.classInterceptorsReversed) {
                classInterceptor.postAfterAll(this.argumentContext, throwable);
            }
        }
        catch (Throwable t) {
            ArgumentTestDescriptor.printStackTrace(t);
            this.throwables.add(t);
        }
        return State.CLOSE;
    }

    private State doClose() {
        if (this.argument instanceof AutoCloseable) {
            try {
                ((AutoCloseable)this.argument).close();
            }
            catch (Throwable t) {
                ArgumentTestDescriptor.printStackTrace(t);
                this.throwables.add(t);
            }
        }
        return State.CLEAN_UP;
    }

    private State doCleanup() {
        ExtendedMap map = this.argumentContext.getMap();
        Set entrySet = map.entrySet();
        for (Map.Entry entry : entrySet) {
            if (!(entry.getValue() instanceof AutoCloseable)) continue;
            try {
                ((AutoCloseable)entry.getValue()).close();
            }
            catch (Throwable t) {
                ArgumentTestDescriptor.printStackTrace(t);
                this.throwables.add(t);
            }
        }
        map.clear();
        return State.END;
    }

    private static enum State {
        START,
        BEFORE_ALL,
        TEST_DEPENDENT,
        TEST_INDEPENDENT,
        SKIP,
        AFTER_ALL,
        CLOSE,
        CLEAN_UP,
        END;

    }
}

