/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.filter;

import 6bc6660d778dec84d62bc72b295ffd7b.org.yaml.snakeyaml.Yaml;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.verifyica.engine.configuration.ConcreteConfiguration;
import org.verifyica.engine.exception.EngineConfigurationException;
import org.verifyica.engine.filter.ExcludeClassFilter;
import org.verifyica.engine.filter.ExcludeTaggedClassFilter;
import org.verifyica.engine.filter.Filter;
import org.verifyica.engine.filter.IncludeClassFilter;
import org.verifyica.engine.filter.IncludeTaggedClassFilter;

public class FilterFactory {
    private static final Map<String, Filter.Type> filterTypeMap = new HashMap<String, Filter.Type>();

    private FilterFactory() {
    }

    public static List<Filter> loadFilters() {
        String filtersFilename = null;
        try {
            ArrayList<Filter> filters = new ArrayList<Filter>();
            filtersFilename = ConcreteConfiguration.getInstance().getProperties().getProperty("verifyica.engine.filter.definitions.filename", null);
            if (filtersFilename != null && !filtersFilename.trim().isEmpty()) {
                List objects = (List)new Yaml().load(FilterFactory.loadContents(new File(filtersFilename)));
                block10: for (Object object : objects) {
                    Map filterMap = (Map)object;
                    String type = (String)filterMap.get("type");
                    boolean enabled = Boolean.TRUE.equals(filterMap.get("enabled"));
                    if (!enabled) continue;
                    Filter.Type decodedType = filterTypeMap.getOrDefault(type, Filter.Type.UNKNOWN);
                    switch (decodedType) {
                        case INCLUDE_CLASS: {
                            String classRegex = (String)filterMap.get("classRegex");
                            filters.add(IncludeClassFilter.create(classRegex));
                            continue block10;
                        }
                        case EXCLUDE_CLASS: {
                            String classRegex = (String)filterMap.get("classRegex");
                            filters.add(ExcludeClassFilter.create(classRegex));
                            continue block10;
                        }
                        case INCLUDE_TAGGED_CLASS: {
                            String classTagRegex = (String)filterMap.get("classTagRegex");
                            filters.add(IncludeTaggedClassFilter.create(classTagRegex));
                            continue block10;
                        }
                        case EXCLUDE_TAGGED_CLASS: {
                            String classTagRegex = (String)filterMap.get("classTagRegex");
                            filters.add(ExcludeTaggedClassFilter.create(classTagRegex));
                        }
                    }
                    throw new EngineConfigurationException(String.format("Invalid filter type [%s]", type));
                }
            }
            return filters;
        }
        catch (EngineConfigurationException e) {
            throw e;
        }
        catch (IOException e) {
            throw new EngineConfigurationException(String.format("Exception loading filter definition file [%s]", filtersFilename), e);
        }
        catch (Throwable t) {
            throw new EngineConfigurationException(String.format("Invalid filter definition file [%s]", filtersFilename), t);
        }
    }

    private static String loadContents(File file) throws IOException {
        Path path = Paths.get(file.getAbsolutePath(), new String[0]);
        byte[] bytes = Files.readAllBytes(path);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    static {
        filterTypeMap.put("IncludeClass", Filter.Type.INCLUDE_CLASS);
        filterTypeMap.put("ExcludeClass", Filter.Type.EXCLUDE_CLASS);
        filterTypeMap.put("IncludeTaggedClass", Filter.Type.INCLUDE_TAGGED_CLASS);
        filterTypeMap.put("ExcludeTaggedClass", Filter.Type.EXCLUDE_TAGGED_CLASS);
    }
}

