/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.logger;

import java.io.PrintStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.verifyica.engine.common.Precondition;
import org.verifyica.engine.configuration.ConcreteConfiguration;
import org.verifyica.engine.logger.Level;

public class Logger {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS", Locale.getDefault());
    private final String name;
    private final AtomicReference<Level> level;

    Logger(String name) {
        this.name = name;
        this.level = new AtomicReference<Level>(Level.INFO);
        ConcreteConfiguration configuration = ConcreteConfiguration.getInstance();
        String loggerLevel = configuration.getProperties().getProperty("verifyica.engine.logger.level", Level.INFO.toString());
        String regex = configuration.getProperties().getProperty("verifyica.engine.logger.regex", ".*");
        try {
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(name);
            if (matcher.find()) {
                this.level.set(Level.decode(loggerLevel));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isTraceEnabled() {
        return this.level.get().toInt() >= Level.TRACE.toInt();
    }

    public boolean isDebugEnabled() {
        return this.level.get().toInt() >= Level.DEBUG.toInt();
    }

    public boolean isInfoEnabled() {
        return this.level.get().toInt() >= Level.INFO.toInt();
    }

    public boolean isWarnEnabled() {
        return this.level.get().toInt() >= Level.WARN.toInt();
    }

    public boolean isErrorEnabled() {
        return this.level.get().toInt() >= Level.ERROR.toInt();
    }

    public void setLevel(Level level) {
        Precondition.notNull(level, "level is null");
        this.level.set(level);
    }

    public boolean isEnabled(Level level) {
        Precondition.notNull(level, "level is null");
        return this.level.get().toInt() >= level.toInt();
    }

    public void trace(String message) {
        if (this.isTraceEnabled()) {
            this.log(System.out, Level.TRACE, "%s", message);
        }
    }

    public void trace(String format, Object ... objects) {
        Precondition.notBlank(format, "format is null", "format is blank");
        if (this.isTraceEnabled()) {
            this.log(System.out, Level.TRACE, format, objects);
        }
    }

    public void debug(String message) {
        if (this.isDebugEnabled()) {
            this.log(System.out, Level.DEBUG, "%s", message);
        }
    }

    public void debug(String format, Object ... objects) {
        Precondition.notBlank(format, "format is null", "format is blank");
        if (this.isDebugEnabled()) {
            this.log(System.out, Level.DEBUG, format, objects);
        }
    }

    public void info(String message) {
        if (this.isInfoEnabled()) {
            this.log(System.out, Level.INFO, "%s", message);
        }
    }

    public void info(String format, Object ... objects) {
        Precondition.notBlank(format, "format is null", "format is blank");
        if (this.isInfoEnabled()) {
            this.log(System.out, Level.INFO, format, objects);
        }
    }

    public void warn(String message) {
        if (this.isWarnEnabled()) {
            this.log(System.out, Level.WARN, "%s", message);
        }
    }

    public void warn(String format, Object ... objects) {
        Precondition.notBlank(format, "format is null", "format is blank");
        if (this.isWarnEnabled()) {
            this.log(System.out, Level.WARN, format, objects);
        }
    }

    public void error(String message) {
        if (this.isErrorEnabled()) {
            this.log(System.err, Level.ERROR, "%s", message);
        }
    }

    public void error(String format, Object ... objects) {
        Precondition.notBlank(format, "format is null", "format is blank");
        if (this.isErrorEnabled()) {
            this.log(System.err, Level.ERROR, format, objects);
        }
    }

    public void flush() {
        System.err.flush();
        System.out.flush();
    }

    private void log(PrintStream printStream, Level level, String format, Object ... objects) {
        printStream.println(LocalDateTime.now().format(DATE_TIME_FORMATTER) + " | " + Thread.currentThread().getName() + " | " + level.toString() + " | " + this.name + " | " + String.format(format, objects));
    }
}

