/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.logger;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.verifyica.engine.logger.Logger;

public final class LoggerFactory {
    private static final Logger ROOT_LOGGER = new Logger("ROOT");
    private final Map<String, Logger> loggers = new ConcurrentHashMap<String, Logger>();

    private LoggerFactory() {
    }

    private Logger getOrCreateLogger(String name) {
        return this.loggers.computeIfAbsent(name, Logger::new);
    }

    public static Logger getLogger(Class<?> clazz) {
        return clazz != null ? LoggerFactory.getLogger(clazz.getName()) : ROOT_LOGGER;
    }

    public static Logger getLogger(String name) {
        Logger logger = null;
        if (name != null && !name.trim().isEmpty()) {
            logger = SingletonHolder.SINGLETON.getOrCreateLogger(name.trim());
        }
        return logger != null ? logger : ROOT_LOGGER;
    }

    private static final class SingletonHolder {
        private static final LoggerFactory SINGLETON = new LoggerFactory();

        private SingletonHolder() {
        }
    }
}

