/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.resolver;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.discovery.ClassSelector;
import org.verifyica.engine.common.Stopwatch;
import org.verifyica.engine.logger.Logger;
import org.verifyica.engine.logger.LoggerFactory;
import org.verifyica.engine.resolver.ResolverPredicates;
import org.verifyica.engine.support.ClassSupport;
import org.verifyica.engine.support.HierarchyTraversalMode;
import org.verifyica.engine.support.OrderSupport;

public class ClassSelectorResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassSelectorResolver.class);

    public void resolve(EngineDiscoveryRequest engineDiscoveryRequest, Map<Class<?>, Set<Method>> classMethodSet) {
        LOGGER.trace("resolve()");
        Stopwatch stopwatch = new Stopwatch();
        AtomicInteger classSelectorCount = new AtomicInteger();
        engineDiscoveryRequest.getSelectorsByType(ClassSelector.class).forEach(classSelector -> {
            classSelectorCount.incrementAndGet();
            Class testClass = classSelector.getJavaClass();
            if (ResolverPredicates.TEST_CLASS.test(testClass)) {
                classMethodSet.computeIfAbsent(testClass, set -> new LinkedHashSet()).addAll(OrderSupport.orderMethods(ClassSupport.findMethods(testClass, ResolverPredicates.TEST_METHOD, HierarchyTraversalMode.BOTTOM_UP)));
            }
            this.processInnerClasses(testClass, classMethodSet);
        });
        LOGGER.trace("resolve() classSelectors [%d] elapsedTime [%d] ms", classSelectorCount.get(), stopwatch.elapsedTime().toMillis());
    }

    private void processInnerClasses(Class<?> testClass, Map<Class<?>, Set<Method>> classMethodSet) {
        Class<?>[] innerClasses;
        for (Class<?> innerClass : innerClasses = testClass.getDeclaredClasses()) {
            this.processInnerClasses(innerClass, classMethodSet);
        }
        if (ResolverPredicates.TEST_CLASS.test(testClass)) {
            classMethodSet.computeIfAbsent(testClass, set -> new LinkedHashSet()).addAll(OrderSupport.orderMethods(ClassSupport.findMethods(testClass, ResolverPredicates.TEST_METHOD, HierarchyTraversalMode.BOTTOM_UP)));
        }
    }
}

