/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.resolver;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.verifyica.api.Argument;
import org.verifyica.engine.api.ClassDefinition;
import org.verifyica.engine.api.MethodDefinition;

public class ConcreteClassDefinition
implements ClassDefinition {
    private final Class<?> testClass;
    private final Set<MethodDefinition> testMethodDefinitions;
    private final List<Argument<?>> arguments;
    private final Set<String> tags;
    private final int argumentParallelism;
    private String displayName;

    public ConcreteClassDefinition(Class<?> testClass, String displayName, Set<String> tags, List<MethodDefinition> testMethodDefinitions, List<Argument<?>> arguments, int argumentParallelism) {
        this.testClass = testClass;
        this.displayName = displayName;
        this.tags = tags;
        this.testMethodDefinitions = new LinkedHashSet<MethodDefinition>(testMethodDefinitions);
        this.arguments = arguments;
        this.argumentParallelism = argumentParallelism;
    }

    @Override
    public Class<?> getTestClass() {
        return this.testClass;
    }

    @Override
    public void setDisplayName(String displayName) {
        if (displayName != null && !displayName.trim().isEmpty()) {
            this.displayName = displayName.trim();
        }
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public Set<String> getTags() {
        return this.tags;
    }

    @Override
    public Set<MethodDefinition> getTestMethodDefinitions() {
        return this.testMethodDefinitions;
    }

    @Override
    public List<Argument<?>> getArguments() {
        return this.arguments;
    }

    @Override
    public int getArgumentParallelism() {
        return this.argumentParallelism;
    }

    public String toString() {
        return "ConcreteClassDefinition{testClass=" + this.testClass + ", displayName=" + this.displayName + ", argumentParallelism=" + this.argumentParallelism + ", testMethodDefinitions=" + this.testMethodDefinitions + ", testArguments=" + this.arguments + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConcreteClassDefinition that = (ConcreteClassDefinition)o;
        return Objects.equals(this.testClass, that.testClass) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.testMethodDefinitions, that.testMethodDefinitions) && Objects.equals(this.arguments, that.arguments);
    }

    public int hashCode() {
        return Objects.hash(this.testClass, this.testMethodDefinitions, this.arguments);
    }
}

