/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.support;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.verifyica.api.Verifyica;
import org.verifyica.engine.common.Precondition;
import org.verifyica.engine.support.DisplayNameSupport;

public class OrderSupport {
    private OrderSupport() {
    }

    public static void orderClasses(List<Class<?>> classes) {
        Precondition.notNull(classes, "classes is null");
        classes.sort(Comparator.comparing(DisplayNameSupport::getDisplayName));
        classes.sort(Comparator.comparingInt(OrderSupport::getOrder));
    }

    public static int getOrder(Class<?> clazz) {
        Precondition.notNull(clazz, "clazz is null");
        int order = 0;
        Verifyica.Order annotation = clazz.getAnnotation(Verifyica.Order.class);
        if (annotation != null) {
            order = annotation.value();
        }
        return order;
    }

    public static List<Method> orderMethods(List<Method> methods) {
        Precondition.notNull(methods, "methods is null");
        methods.sort(Comparator.comparing(DisplayNameSupport::getDisplayName));
        methods.sort((m1, m2) -> {
            Verifyica.Order o1 = m1.getAnnotation(Verifyica.Order.class);
            Verifyica.Order o2 = m2.getAnnotation(Verifyica.Order.class);
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            int orderValue1 = o1.value();
            int orderValue2 = o2.value();
            if (orderValue1 == 0 && orderValue2 == 0) {
                return 0;
            }
            if (orderValue1 == 0) {
                return -1;
            }
            if (orderValue2 == 0) {
                return 1;
            }
            return Integer.compare(orderValue1, orderValue2);
        });
        return methods;
    }

    public static Set<Method> orderMethods(Set<Method> methods) {
        List<Method> list = OrderSupport.orderMethods(new ArrayList<Method>(methods));
        methods.clear();
        methods.addAll(list);
        return methods;
    }
}

