/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class EphemeralExecutorService
extends AbstractExecutorService {
    private final ThreadFactory threadFactory;
    private final List<Thread> runningThreads;
    private volatile boolean isShutdown;

    public EphemeralExecutorService(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        this.runningThreads = Collections.synchronizedList(new ArrayList());
    }

    @Override
    public void execute(Runnable runnable) {
        if (this.isShutdown) {
            throw new IllegalStateException("Executor service is shut down");
        }
        Thread thread = this.threadFactory.newThread(() -> {
            try {
                this.runningThreads.add(Thread.currentThread());
                runnable.run();
            }
            finally {
                this.runningThreads.remove(Thread.currentThread());
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void shutdown() {
        this.isShutdown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        this.isShutdown = true;
        List<Thread> list = this.runningThreads;
        synchronized (list) {
            for (Thread thread : this.runningThreads) {
                thread.interrupt();
            }
        }
        return new ArrayList<Runnable>();
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown && this.runningThreads.isEmpty();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        while (!this.isTerminated()) {
            long remainingTime = deadline - System.nanoTime();
            if (remainingTime <= 0L) {
                return false;
            }
            long sleepTimeMillis = Math.min(TimeUnit.NANOSECONDS.toMillis(remainingTime), 1000L);
            Thread.sleep(sleepTimeMillis);
        }
        return true;
    }
}

