/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.common;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Optional;
import org.verifyica.engine.common.AnsiColor;
import org.verifyica.engine.configuration.ConcreteConfiguration;

public class StackTracePrinter {
    private static boolean pruneStackTraces = true;

    private StackTracePrinter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printStackTrace(Throwable throwable, AnsiColor ansiColor, PrintStream printStream) {
        if (pruneStackTraces) {
            StackTracePrinter.pruneStackTrace(throwable);
        }
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            printStream.print(ansiColor);
            throwable.printStackTrace(printStream);
            printStream.print(AnsiColor.NONE);
        }
    }

    private static void pruneStackTrace(Throwable throwable) {
        for (Throwable cause = throwable; cause != null; cause = cause.getCause()) {
            StackTracePrinter.trimStackTrace(cause);
        }
    }

    private static void trimStackTrace(Throwable throwable) {
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        throwable.setStackTrace(Arrays.copyOf(stackTrace, StackTracePrinter.length(stackTrace)));
    }

    private static int length(StackTraceElement[] stackTrace) {
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement element = stackTrace[i];
            if (!element.getClassName().startsWith("org.verifyica.engine.")) continue;
            return i;
        }
        return stackTrace.length;
    }

    static {
        Optional.ofNullable(ConcreteConfiguration.getInstance().getProperties().getProperty("verifyica.engine.prune.stacktraces")).ifPresent(value -> {
            if ("false".equals(value)) {
                pruneStackTraces = false;
            }
        });
    }
}

