/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.configuration;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.verifyica.api.Configuration;
import org.verifyica.engine.common.OrderedProperties;
import org.verifyica.engine.exception.EngineConfigurationException;

public class ConcreteConfiguration
implements Configuration {
    private static final String VERIFYICA_CONFIGURATION_TRACE = "VERIFYICA_CONFIGURATION_TRACE";
    private static final String VERIFYICA_PROPERTIES_FILENAME = "verifyica.properties";
    private static final boolean IS_TRACE_ENABLED = "true".equals(System.getenv().get("VERIFYICA_CONFIGURATION_TRACE"));
    private static final String CLASS_NAME = ConcreteConfiguration.class.getName();
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS", Locale.getDefault());
    private final Properties properties = this.load();
    private Path propertiesPath;

    private ConcreteConfiguration() {
    }

    public Optional<Path> getPropertiesPath() {
        return Optional.ofNullable(this.propertiesPath);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public static ConcreteConfiguration getInstance() {
        return SingletonHolder.SINGLETON;
    }

    private Properties load() {
        OrderedProperties properties;
        block16: {
            if (IS_TRACE_ENABLED) {
                ConcreteConfiguration.trace("load()");
            }
            properties = new OrderedProperties();
            try {
                Optional<File> optional = Optional.ofNullable(System.getProperties().get(VERIFYICA_PROPERTIES_FILENAME)).map(value -> new File(value.toString()).getAbsoluteFile());
                if (!optional.isPresent()) {
                    optional = ConcreteConfiguration.find(Paths.get(".", new String[0]), VERIFYICA_PROPERTIES_FILENAME);
                }
                if (optional.isPresent()) {
                    if (IS_TRACE_ENABLED) {
                        ConcreteConfiguration.trace("loading [" + optional.get().getAbsolutePath() + "]");
                    }
                    this.propertiesPath = optional.get().toPath().toAbsolutePath();
                    try (BufferedReader reader = Files.newBufferedReader(optional.get().toPath(), StandardCharsets.UTF_8);){
                        ((Properties)properties).load(reader);
                    }
                    if (IS_TRACE_ENABLED) {
                        ConcreteConfiguration.trace("loaded [" + optional.get().getAbsolutePath() + "]");
                    }
                    break block16;
                }
                if (IS_TRACE_ENABLED) {
                    ConcreteConfiguration.trace("no configuration properties file found");
                }
            }
            catch (IOException e) {
                throw new EngineConfigurationException("Exception loading configuration properties", e);
            }
        }
        if (IS_TRACE_ENABLED) {
            ConcreteConfiguration.trace("configuration properties ...");
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> ConcreteConfiguration.trace("configuration property [" + key + "] = [" + value + "]")));
        }
        return properties;
    }

    private static Optional<File> find(Path path, String filename) {
        Path currentPath = path.toAbsolutePath().normalize();
        while (true) {
            File file;
            if (IS_TRACE_ENABLED) {
                String currentPathString = currentPath.toString();
                if (!currentPathString.endsWith("/")) {
                    currentPathString = currentPathString + "/";
                }
                ConcreteConfiguration.trace("searching path [" + currentPathString + "]");
            }
            if ((file = new File(currentPath.toAbsolutePath() + File.separator + filename)).exists() && file.isFile() && file.canRead()) {
                if (IS_TRACE_ENABLED) {
                    ConcreteConfiguration.trace("found [" + file.getAbsoluteFile() + "]");
                }
                return Optional.of(file);
            }
            if ((currentPath = currentPath.getParent()) == null) break;
            currentPath = currentPath.toAbsolutePath().normalize();
        }
        return Optional.empty();
    }

    private static void trace(String message) {
        if (IS_TRACE_ENABLED) {
            System.out.println(LocalDateTime.now().format(DATE_TIME_FORMATTER) + " | " + Thread.currentThread().getName() + " | TRACE | " + CLASS_NAME + " | " + message + " ");
        }
    }

    private static class SingletonHolder {
        private static final ConcreteConfiguration SINGLETON = new ConcreteConfiguration();

        private SingletonHolder() {
        }
    }
}

