/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.descriptor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.verifyica.api.Configuration;
import org.verifyica.engine.common.AnsiColor;
import org.verifyica.engine.common.StackTracePrinter;
import org.verifyica.engine.common.Throttle;
import org.verifyica.engine.descriptor.TestDescriptorStatus;
import org.verifyica.engine.exception.TestClassDefinitionException;
import org.verifyica.engine.inject.Inject;
import org.verifyica.engine.inject.Named;

public abstract class TestableTestDescriptor
extends AbstractTestDescriptor {
    public static final String ENGINE_EXECUTION_LISTENER = "engineExecutionListener";
    public static final String CLASS_INTERCEPTORS = "classInterceptors";
    public static final String CLASS_INTERCEPTORS_REVERSED = "classInterceptorsReversed";
    public static final String ARGUMENT_EXECUTOR_SERVICE = "argumentExecutorService";
    public static final String ENGINE_CONTEXT = "engineContext";
    public static final String CLASS_CONTEXT = "classContext";
    public static final String ARGUMENT_CONTEXT = "argumentContext";
    public static final Predicate<TestDescriptor> TESTABLE_TEST_DESCRIPTOR_FILTER = testDescriptor -> testDescriptor instanceof TestableTestDescriptor;
    public static final Function<TestDescriptor, TestableTestDescriptor> TESTABLE_TEST_DESCRIPTOR_MAPPER = testDescriptor -> (TestableTestDescriptor)((Object)testDescriptor);
    @Inject
    @Named(value="engineExecutionListener")
    private EngineExecutionListener engineExecutionListener;
    private TestDescriptorStatus testDescriptorStatus;

    protected TestableTestDescriptor(UniqueId uniqueId, String displayName) {
        super(uniqueId, displayName);
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    public abstract TestableTestDescriptor test();

    public abstract void skip();

    public TestDescriptorStatus getTestDescriptorStatus() {
        return this.testDescriptorStatus;
    }

    protected void setTestDescriptorStatus(TestDescriptorStatus testDescriptorStatus) {
        this.testDescriptorStatus = testDescriptorStatus;
    }

    protected static void invoke(Method method, Object instance, List<Object> arguments) throws InvocationTargetException, IllegalAccessException {
        TestableTestDescriptor.invoke(method, instance, arguments, false);
    }

    protected static void invoke(Method method, Object instance, List<Object> arguments, boolean noParameters) throws InvocationTargetException, IllegalAccessException {
        if (method.getParameterCount() == 1) {
            Class<?> parameterType = method.getParameterTypes()[0];
            for (Object argument : arguments) {
                if (!parameterType.isInstance(argument)) continue;
                method.invoke(instance, argument);
                return;
            }
        }
        if (method.getParameterCount() == 0 && noParameters) {
            method.invoke(instance, new Object[0]);
            return;
        }
        throw new TestClassDefinitionException(String.format("Test class [%s] method [%s] invalid argument type", method.getDeclaringClass().getName(), method.getName()));
    }

    protected Throttle createThrottle(Configuration configuration, String name) {
        String value = configuration.getProperties().getProperty(name);
        if (value != null && !value.trim().isEmpty()) {
            try {
                String[] tokens = value.split("[\\s,]+");
                if (tokens.length == 1) {
                    return new Throttle(name, Long.parseLong(tokens[0]), Long.parseLong(tokens[0]));
                }
                if (tokens.length == 2) {
                    return new Throttle(name, Long.parseLong(tokens[0]), Long.parseLong(tokens[1]));
                }
                return new Throttle(name, 0L, 0L);
            }
            catch (Throwable t) {
                return new Throttle(name, 0L, 0L);
            }
        }
        return new Throttle(name, 0L, 0L);
    }

    protected static void printStackTrace(Throwable throwable) {
        StackTracePrinter.printStackTrace(throwable, AnsiColor.TEXT_RED_BOLD, System.err);
    }
}

