/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.verifyica.engine.exception.EngineException;
import org.verifyica.engine.inject.Inject;
import org.verifyica.engine.inject.Named;

public class Injector {
    private static final Map<Class<?>, List<Field>> FIELD_CACHE = new ConcurrentHashMap();

    private Injector() {
    }

    public static void inject(String name, Object value, Object target) {
        for (Class<?> clazz = target.getClass(); clazz != null && !clazz.getName().startsWith("java") && !clazz.getName().startsWith("sun"); clazz = clazz.getSuperclass()) {
            for (Field field : Injector.getFields(clazz)) {
                Inject inject = field.getAnnotation(Inject.class);
                Named named = field.getAnnotation(Named.class);
                if (inject == null || named == null || !named.value().equals(name) || Modifier.isStatic(field.getModifiers()) || !field.getType().isAssignableFrom(value.getClass())) continue;
                Injector.injectField(field, target, value);
            }
        }
    }

    public static void inject(Class<? extends Annotation> annotation, Object value, Object target) {
        for (Class<?> clazz = target.getClass(); clazz != null && !clazz.getName().startsWith("java") && !clazz.getName().startsWith("sun"); clazz = clazz.getSuperclass()) {
            for (Field field : Injector.getFields(clazz)) {
                if (Modifier.isStatic(field.getModifiers()) || !field.isAnnotationPresent(annotation) || !field.getType().isAssignableFrom(value.getClass())) continue;
                Injector.injectField(field, target, value);
            }
        }
    }

    public static void inject(Class<? extends Annotation> annotation, Object value, Class<?> target) {
        for (Class<?> clazz = target; clazz != null && !clazz.getName().startsWith("java") && !clazz.getName().startsWith("sun"); clazz = clazz.getSuperclass()) {
            for (Field field : Injector.getFields(clazz)) {
                if (!Modifier.isStatic(field.getModifiers()) || !field.isAnnotationPresent(annotation) || !field.getType().isAssignableFrom(value.getClass())) continue;
                Injector.injectField(field, null, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void injectField(Field field, Object target, Object value) {
        Field field2 = field;
        synchronized (field2) {
            boolean originalAccessibility = field.isAccessible();
            try {
                field.setAccessible(true);
                field.set(target, value);
            }
            catch (IllegalAccessException e) {
                throw new EngineException(String.format("Exception injecting object into field [%s]", field.getName()), e);
            }
            finally {
                field.setAccessible(originalAccessibility);
            }
        }
    }

    private static List<Field> getFields(Class<?> clazz) {
        return FIELD_CACHE.computeIfAbsent(clazz, c -> Arrays.asList(c.getDeclaredFields()));
    }
}

