/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.support;

import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.verifyica.engine.common.Precondition;
import org.verifyica.engine.logger.Logger;
import org.verifyica.engine.logger.LoggerFactory;

public class ExecutorServiceSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutorServiceSupport.class);
    private static final String PLATFORM = "platform";
    private static final String EPHEMERAL = "ephemeral";

    private ExecutorServiceSupport() {
    }

    public static void waitForAllFutures(Collection<Future<?>> futures, ExecutorService executorService) {
        Precondition.notNull(futures, "futures is null");
        Precondition.notNull(executorService, "executorService is null");
        LOGGER.trace("waitForAllFutures() futures [%d]", futures.size());
        ExecutorCompletionService<Object> completionService = new ExecutorCompletionService<Object>(executorService);
        HashMap futureMap = new HashMap();
        for (Future<?> future : futures) {
            futureMap.put(completionService.submit(future::get), future);
        }
        for (int i = 0; i < futures.size(); ++i) {
            try {
                Future completedFuture = completionService.take();
                futureMap.get(completedFuture);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                System.err.printf("Error waiting for future [%s]%n", e.getMessage());
            }
        }
    }

    public static void shutdownAndAwaitTermination(ExecutorService executorService) {
        Precondition.notNull(executorService, "executorService is null");
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                executorService.shutdownNow();
                if (!executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                    LOGGER.error("ExecutorService did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

