/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.support;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.verifyica.api.Verifyica;
import org.verifyica.engine.common.Precondition;
import org.verifyica.engine.exception.TestClassDefinitionException;
import org.verifyica.engine.support.DisplayNameSupport;

public class OrderSupport {
    private OrderSupport() {
    }

    public static List<Class<?>> orderClasses(List<Class<?>> classes) {
        Precondition.notNull(classes, "classes is null");
        classes.sort(Comparator.comparing(DisplayNameSupport::getDisplayName));
        classes.sort((c1, c2) -> {
            Verifyica.Order o1 = c1.getAnnotation(Verifyica.Order.class);
            Verifyica.Order o2 = c2.getAnnotation(Verifyica.Order.class);
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            int orderValue1 = o1.value();
            int orderValue2 = o2.value();
            if (orderValue1 == 0 && orderValue2 == 0) {
                return 0;
            }
            if (orderValue1 == 0) {
                return -1;
            }
            if (orderValue2 == 0) {
                return 1;
            }
            return Integer.compare(orderValue1, orderValue2);
        });
        return classes;
    }

    public static Set<Class<?>> orderClasses(Set<Class<?>> classes) {
        List<Class<?>> list = OrderSupport.orderClasses(new ArrayList(classes));
        classes.clear();
        classes.addAll(list);
        return classes;
    }

    public static int getOrder(Class<?> clazz) {
        Precondition.notNull(clazz, "clazz is null");
        int order = 0;
        Verifyica.Order annotation = clazz.getAnnotation(Verifyica.Order.class);
        if (annotation != null) {
            order = annotation.value();
        }
        return order;
    }

    public static List<Method> orderMethods(List<Method> methods) {
        Precondition.notNull(methods, "methods is null");
        methods.sort(Comparator.comparing(DisplayNameSupport::getDisplayName));
        methods.sort((m1, m2) -> {
            Verifyica.Order o1 = m1.getAnnotation(Verifyica.Order.class);
            Verifyica.Order o2 = m2.getAnnotation(Verifyica.Order.class);
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            int orderValue1 = o1.value();
            int orderValue2 = o2.value();
            if (orderValue1 == 0 && orderValue2 == 0) {
                return 0;
            }
            if (orderValue1 == 0) {
                return -1;
            }
            if (orderValue2 == 0) {
                return 1;
            }
            return Integer.compare(orderValue1, orderValue2);
        });
        OrderSupport.orderMethodsByDependencies(methods);
        return methods;
    }

    public static Set<Method> orderMethods(Set<Method> methods) {
        List<Method> list = OrderSupport.orderMethods(new ArrayList<Method>(methods));
        methods.clear();
        methods.addAll(list);
        return methods;
    }

    private static List<Method> orderMethodsByDependencies(List<Method> methods) {
        HashMap<String, Method> methodMap = new HashMap<String, Method>();
        HashMap<String, Integer> originalOrder = new HashMap<String, Integer>();
        for (int i = 0; i < methods.size(); ++i) {
            Method method2 = methods.get(i);
            String tag = OrderSupport.getMethodTag(method2);
            methodMap.put(tag, method2);
            originalOrder.put(tag, i);
        }
        HashMap<String, Set<String>> dependents = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> dependencies = new HashMap<String, Set<String>>();
        methods.forEach(method -> {
            String methodTag = OrderSupport.getMethodTag(method);
            dependents.put(methodTag, new HashSet());
            dependencies.put(methodTag, new HashSet());
        });
        for (Method method3 : methods) {
            Verifyica.DependsOn[] dependsOnAnnotations = (Verifyica.DependsOn[])method3.getAnnotationsByType(Verifyica.DependsOn.class);
            if (dependsOnAnnotations == null || dependsOnAnnotations.length <= 0) continue;
            String dependent = OrderSupport.getMethodTag(method3);
            for (Verifyica.DependsOn dependency : dependsOnAnnotations) {
                String dependencyTag = dependency.value();
                if (!methodMap.containsKey(dependencyTag)) {
                    throw new TestClassDefinitionException(String.format("Dependency tag [%s] not found for method tag [%s]", dependencyTag, dependent));
                }
                ((Set)dependents.get(dependencyTag)).add(dependent);
                ((Set)dependencies.get(dependent)).add(dependencyTag);
            }
        }
        ArrayList<Method> result = new ArrayList<Method>();
        HashSet<String> processed = new HashSet<String>();
        HashSet<String> processing = new HashSet<String>();
        for (Method method4 : methods) {
            String methodTag = OrderSupport.getMethodTag(method4);
            if (processed.contains(methodTag) || !((Set)dependencies.get(methodTag)).isEmpty()) continue;
            OrderSupport.processMethodAndDependents(methodTag, methodMap, dependents, dependencies, processed, processing, result, originalOrder);
        }
        for (Method method4 : methods) {
            String methodTag = OrderSupport.getMethodTag(method4);
            if (processed.contains(methodTag)) continue;
            OrderSupport.processMethodAndDependents(methodTag, methodMap, dependents, dependencies, processed, processing, result, originalOrder);
        }
        if (result.size() != methods.size()) {
            throw new TestClassDefinitionException("Circular dependency detected in method ordering");
        }
        methods.clear();
        methods.addAll(result);
        return result;
    }

    private static void processMethodAndDependents(String methodTag, Map<String, Method> methodMap, Map<String, Set<String>> dependents, Map<String, Set<String>> dependencies, Set<String> processed, Set<String> processing, List<Method> result, Map<String, Integer> originalOrder) {
        if (processing.contains(methodTag)) {
            throw new TestClassDefinitionException(String.format("Circular dependency detected involving method tag [%s]", methodTag));
        }
        if (processed.contains(methodTag)) {
            return;
        }
        processing.add(methodTag);
        for (String dependency : dependencies.get(methodTag)) {
            if (processed.contains(dependency)) continue;
            OrderSupport.processMethodAndDependents(dependency, methodMap, dependents, dependencies, processed, processing, result, originalOrder);
        }
        result.add(methodMap.get(methodTag));
        processed.add(methodTag);
        List readyDependents = dependents.get(methodTag).stream().filter(dependent -> {
            if (processed.contains(dependent)) return false;
            if (!((Set)dependencies.get(dependent)).stream().allMatch(processed::contains)) return false;
            return true;
        }).sorted((a, b) -> {
            Set depsB;
            Set depsA = (Set)dependencies.get(a);
            if (depsA.equals(depsB = (Set)dependencies.get(b))) {
                return ((Integer)originalOrder.get(a)).compareTo((Integer)originalOrder.get(b));
            }
            return depsA.size() != depsB.size() ? Integer.compare(depsA.size(), depsB.size()) : ((Integer)originalOrder.get(a)).compareTo((Integer)originalOrder.get(b));
        }).collect(Collectors.toList());
        for (String dependent2 : readyDependents) {
            OrderSupport.processMethodAndDependents(dependent2, methodMap, dependents, dependencies, processed, processing, result, originalOrder);
        }
        processing.remove(methodTag);
    }

    private static String getMethodTag(Method method) {
        Verifyica.Tag tagAnnotation = method.getAnnotation(Verifyica.Tag.class);
        return tagAnnotation != null ? tagAnnotation.value() : method.getName();
    }
}

