/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.verifyica.api.Configuration;
import org.verifyica.engine.VerifyicaTestEngine;
import org.verifyica.engine.common.AnsiColor;
import org.verifyica.engine.common.AnsiColoredString;
import org.verifyica.engine.common.Stopwatch;
import org.verifyica.engine.configuration.ConcreteConfiguration;
import org.verifyica.engine.configuration.ConcreteConfigurationParameters;
import org.verifyica.engine.descriptor.TestableTestDescriptor;
import org.verifyica.engine.exception.TestClassDefinitionException;
import org.verifyica.engine.listener.ChainedEngineExecutionListener;
import org.verifyica.engine.listener.StatusEngineExecutionListener;
import org.verifyica.engine.listener.SummaryEngineExecutionListener2;
import org.verifyica.engine.listener.TracingEngineExecutionListener;
import org.verifyica.engine.support.TimestampSupport;

@Mojo(name="test", threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class VerifyicaMavenPlugin
extends AbstractMojo {
    private static final String MAVEN_PLUGIN_PROPERTIES_RESOURCE = "/maven-plugin.properties";
    private static final String MAVEN_PLUGIN_VERSION_KEY = "version";
    private static final String UNKNOWN_VERSION = "unknown";
    private static final String INTERACTIVE = "interactive";
    private static final String BATCH = "batch";
    private static final String GROUP_ID = "org.verifyica";
    private static final String ARTIFACT_ID = "maven-plugin";
    public static final String VERSION = VerifyicaMavenPlugin.version();
    private static final String BANNER = new AnsiColoredString().append(AnsiColor.TEXT_WHITE_BRIGHT).append("Verifyica ").append(VerifyicaTestEngine.staticGetVersion()).append(" @ ").append(TimestampSupport.now()).append(AnsiColor.NONE).build();
    private static final String SUMMARY_BANNER = new AnsiColoredString().append(AnsiColor.TEXT_WHITE_BRIGHT).append("Verifyica ").append(VerifyicaTestEngine.staticGetVersion()).append(" Summary @ ").append(TimestampSupport.now()).append(AnsiColor.NONE).build();
    private static final String SEPARATOR = AnsiColor.TEXT_WHITE_BRIGHT.wrap((Object)"------------------------------------------------------------------------");
    private static final String INFO = new AnsiColoredString().append(AnsiColor.TEXT_WHITE).append("[").append(AnsiColor.TEXT_BLUE_BOLD).append("INFO").append(AnsiColor.TEXT_WHITE).append("]").append(AnsiColor.NONE).append(" ").build();
    private static final String ERROR = new AnsiColoredString().append(AnsiColor.TEXT_WHITE).append("[").append(AnsiColor.TEXT_RED_BOLD).append("ERROR").append(AnsiColor.TEXT_WHITE).append("]").append(AnsiColor.NONE).append(" ").build();
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession mavenSession;
    private Logger logger;
    private VerifyicaTestEngine verifyicaTestEngine;

    public Optional<String> getVersion() {
        return Optional.of(VERSION);
    }

    public void execute() throws MojoFailureException, MojoExecutionException {
        TestDescriptor testDescriptor;
        this.initialize();
        if (System.getProperties().containsKey("skipTests") || System.getProperty("skipTests") != null) {
            return;
        }
        Stopwatch stopwatch = new Stopwatch();
        System.out.println(INFO + SEPARATOR);
        System.out.println(INFO + BANNER);
        System.out.println(INFO + SEPARATOR);
        try {
            testDescriptor = this.discovery();
        }
        catch (Throwable t) {
            if (t instanceof TestClassDefinitionException) {
                System.err.println(ERROR + AnsiColor.TEXT_RED_BOLD.wrap((Object)t.getMessage()));
            } else {
                t.printStackTrace(System.err);
            }
            System.out.println(ERROR + SEPARATOR);
            System.out.println(ERROR + SUMMARY_BANNER);
            System.out.println(ERROR + SEPARATOR);
            System.out.println(new AnsiColoredString().append(ERROR).append(AnsiColor.TEXT_RED_BOLD).append("ERROR DURING TEST DISCOVERY").append(AnsiColor.NONE));
            System.out.println(ERROR + SEPARATOR);
            Duration elapsedTime = stopwatch.elapsed();
            System.out.println(new AnsiColoredString().append(ERROR).append(AnsiColor.TEXT_WHITE_BRIGHT).append("Total time  : ").append(TimestampSupport.toHumanReadable((TimestampSupport.Format)TimestampSupport.Format.SHORT, (long)elapsedTime.toNanos())).append(" (").append((double)elapsedTime.toNanos() / 1000000.0).append(" ms)").append(AnsiColor.NONE));
            System.out.println(new AnsiColoredString().append(ERROR).append(AnsiColor.TEXT_WHITE_BRIGHT).append("Finished at : ").append(TimestampSupport.now()).append(AnsiColor.NONE));
            System.out.println(ERROR + SEPARATOR);
            if (t instanceof TestClassDefinitionException) {
                throw new MojoFailureException("");
            }
            throw new MojoExecutionException("");
        }
        try {
            this.execute(testDescriptor);
        }
        catch (Throwable t) {
            throw new MojoExecutionException(t);
        }
        Optional<TestableTestDescriptor> optionalExecutableTestDescriptor = testDescriptor.getDescendants().stream().filter(TestableTestDescriptor.TESTABLE_TEST_DESCRIPTOR_FILTER).map(TestableTestDescriptor.TESTABLE_TEST_DESCRIPTOR_MAPPER).filter(testableTestDescriptor -> testableTestDescriptor.getTestDescriptorStatus().isFailure()).findFirst();
        if (optionalExecutableTestDescriptor.isPresent()) {
            throw new MojoFailureException(optionalExecutableTestDescriptor.get().getTestDescriptorStatus().getThrowable());
        }
    }

    private void initialize() {
        this.logger = Logger.create(this.getLog());
        ConcreteConfiguration configuration = ConcreteConfiguration.getInstance();
        System.getProperties().putAll((Map<?, ?>)configuration.getProperties());
        if (this.mavenProject.getProperties() != null) {
            System.getProperties().putAll((Map<?, ?>)this.mavenProject.getProperties());
        }
        if (this.mavenSession.getSystemProperties() != null) {
            System.getProperties().putAll((Map<?, ?>)this.mavenSession.getSystemProperties());
        }
        if (this.mavenSession.getUserProperties() != null) {
            System.getProperties().putAll((Map<?, ?>)this.mavenSession.getUserProperties());
        }
        configuration.getProperties().setProperty("verifyica.maven.plugin", "true");
        this.logger.debug("property [%s] = [%s]", "verifyica.maven.plugin", "true");
        configuration.getProperties().setProperty("verifyica.maven.plugin.version", VERSION);
        this.logger.debug("property [%s] = [%s]", "verifyica.maven.plugin.version", VERSION);
        if (this.mavenSession.getRequest().isInteractiveMode()) {
            configuration.getProperties().setProperty("verifyica.maven.plugin.mode", INTERACTIVE);
            this.logger.debug("property [%s] = [%s]", "verifyica.maven.plugin.mode", INTERACTIVE);
        } else {
            configuration.getProperties().setProperty("verifyica.maven.plugin.mode", BATCH);
            this.logger.debug("property [%s] = [%s]", "verifyica.maven.plugin.mode", BATCH);
        }
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            this.logger.debug("property [%s] = [%s]", entry.getKey(), entry.getValue());
        }
        this.verifyicaTestEngine = new VerifyicaTestEngine();
    }

    private TestDescriptor discovery() throws Throwable {
        LinkedHashSet<Path> artifactPaths = new LinkedHashSet<Path>();
        artifactPaths.addAll(this.resolveClasspathElements(this.mavenProject.getCompileClasspathElements()));
        artifactPaths.addAll(this.resolveClasspathElements(this.mavenProject.getCompileClasspathElements()));
        artifactPaths.addAll(this.resolveClasspathElements(this.mavenProject.getRuntimeClasspathElements()));
        artifactPaths.addAll(this.resolveClasspathElements(this.mavenProject.getTestClasspathElements()));
        artifactPaths.addAll(this.resolveArtifact(this.mavenProject.getArtifact()));
        artifactPaths.addAll(this.resolveArtifacts(this.mavenProject.getDependencyArtifacts()));
        artifactPaths.addAll(this.resolveArtifacts(this.mavenProject.getAttachedArtifacts()));
        LinkedHashMap<String, URL> urls = new LinkedHashMap<String, URL>();
        for (Path path : artifactPaths) {
            URL url = path.toUri().toURL();
            urls.putIfAbsent(url.getPath(), url);
        }
        System.setProperty("java.class.path", VerifyicaMavenPlugin.buildClasspath(urls.values()));
        URLClassLoader classLoader = new URLClassLoader(urls.values().toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(classLoader);
        LauncherDiscoveryRequest launcherDiscoveryRequest = LauncherDiscoveryRequestBuilder.request().selectors(DiscoverySelectors.selectClasspathRoots(artifactPaths)).filters(new Filter[]{ClassNameFilter.includeClassNamePatterns((String[])new String[]{".*"})}).configurationParameters(Collections.emptyMap()).build();
        return this.verifyicaTestEngine.discover((EngineDiscoveryRequest)launcherDiscoveryRequest, UniqueId.forEngine((String)this.verifyicaTestEngine.getId()));
    }

    private void execute(TestDescriptor testDescriptor) {
        ChainedEngineExecutionListener chainedEngineExecutionListener = new ChainedEngineExecutionListener(new EngineExecutionListener[]{new TracingEngineExecutionListener(), new StatusEngineExecutionListener(), new SummaryEngineExecutionListener2()});
        ExecutionRequest executionRequest = new ExecutionRequest(testDescriptor, (EngineExecutionListener)chainedEngineExecutionListener, (ConfigurationParameters)new ConcreteConfigurationParameters((Configuration)ConcreteConfiguration.getInstance()));
        this.verifyicaTestEngine.execute(executionRequest);
    }

    private Set<Path> resolveClasspathElements(Collection<String> classpathElements) {
        LinkedHashSet<Path> paths = new LinkedHashSet<Path>();
        if (classpathElements != null) {
            for (String classpathElement : classpathElements) {
                File file = new File(classpathElement);
                if (!file.exists()) continue;
                Path path = file.toPath();
                paths.add(path);
                this.logger.debug("classpathElement [%s]", path);
            }
        }
        return paths;
    }

    private Set<Path> resolveArtifact(Artifact artifact) {
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        artifacts.add(artifact);
        return this.resolveArtifacts(artifacts);
    }

    private Set<Path> resolveArtifacts(Collection<Artifact> artifacts) {
        LinkedHashSet<Path> paths = new LinkedHashSet<Path>();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                File file = artifact.getFile();
                if (!file.exists()) continue;
                Path path = file.toPath();
                paths.add(path);
                this.logger.debug("classpathElement [%s]", path);
            }
        }
        return paths;
    }

    private static String buildClasspath(Collection<URL> urls) {
        StringJoiner stringJoiner = new StringJoiner(File.pathSeparator);
        for (URL url : urls) {
            stringJoiner.add(url.getPath());
        }
        return stringJoiner.toString();
    }

    private static String version() {
        String value = UNKNOWN_VERSION;
        try (InputStream inputStream = VerifyicaMavenPlugin.class.getResourceAsStream(MAVEN_PLUGIN_PROPERTIES_RESOURCE);){
            if (inputStream != null) {
                Properties properties = new Properties();
                properties.load(inputStream);
                value = properties.getProperty(MAVEN_PLUGIN_VERSION_KEY).trim();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return value;
    }

    static {
        System.setProperty("verifyica.maven.plugin", "true");
    }

    private static class Logger {
        private final Log log;

        private Logger(Log log) {
            this.log = log;
        }

        public void debug(String format, Object ... objects) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)String.format(format, objects));
            }
        }

        public static Logger create(Log log) {
            return new Logger(log);
        }
    }
}

