/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.comm.channel;

import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.vesalainen.comm.channel.SerialChannel;

class SerialInputStream
extends InputStream {
    private SerialChannel channel;
    private ByteBuffer buffer;
    private boolean online;

    public SerialInputStream(SerialChannel channel, int bufferSize) {
        this.channel = channel;
        this.buffer = ByteBuffer.allocateDirect(bufferSize);
        this.buffer.flip();
    }

    @Override
    public int read() throws IOException {
        if (!this.buffer.hasRemaining()) {
            this.buffer.clear();
            this.channel.read(this.buffer);
            this.buffer.flip();
        }
        try {
            return this.buffer.get() & 0xFF;
        }
        catch (BufferUnderflowException ex) {
            return -1;
        }
    }

    @Override
    public int available() throws IOException {
        return this.buffer.remaining();
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (this.buffer.remaining() < readlimit) {
            throw new IllegalArgumentException("Couldn't set mark for " + readlimit + " bytes");
        }
        this.buffer.mark();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.buffer.hasRemaining()) {
            this.buffer.clear();
            this.channel.read(this.buffer);
            this.buffer.flip();
        }
        int length = Math.min(len, this.buffer.remaining());
        this.buffer.get(b, off, length);
        return length;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.buffer.reset();
    }

    @Override
    public void close() throws IOException {
        this.channel = null;
        this.buffer = null;
    }

    public String toString() {
        return "SerialInputStream{channel=" + this.channel + "buffer=" + this.buffer + '}';
    }
}

