/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.comm.channel;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.vesalainen.comm.channel.SerialChannel;

class SerialOutputStream
extends OutputStream {
    private SerialChannel channel;
    private ByteBuffer buffer;

    public SerialOutputStream(SerialChannel channel, int bufferSize) {
        this.channel = channel;
        this.buffer = ByteBuffer.allocateDirect(bufferSize);
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.buffer.hasRemaining()) {
            this.flushBuffer();
        }
        this.buffer.put((byte)b);
    }

    public void flushBuffer() throws IOException {
        this.buffer.flip();
        while (this.buffer.hasRemaining()) {
            this.channel.write(this.buffer);
        }
        this.buffer.clear();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            if (!this.buffer.hasRemaining()) {
                this.flushBuffer();
            }
            int length = Math.min(len, this.buffer.remaining());
            this.buffer.put(b, off, length);
            len -= length;
            off += length;
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.channel = null;
        this.buffer = null;
    }
}

