/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.comm.channel;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.vesalainen.comm.channel.SerialChannel;
import org.vesalainen.comm.channel.SerialSelector;

public class SpeedDetector {
    private long waitMillis;
    private int testLength;
    private int maxCount;
    private List<Range> ranges = new ArrayList<Range>();
    private List<SerialChannel.Configuration> configurations = new ArrayList<SerialChannel.Configuration>();

    public SpeedDetector() {
        this(1000L, 20, 100);
    }

    public SpeedDetector(long waitMillis, int testLength, int maxCount) {
        this.waitMillis = waitMillis;
        this.testLength = testLength;
        this.maxCount = maxCount;
    }

    public void addRange(byte b) {
        this.ranges.add(new Range(b));
    }

    public void addRange(byte start, byte end) {
        this.ranges.add(new Range(start, end));
    }

    public void addSpeed(SerialChannel.Speed speed) {
        this.configurations.add(new SerialChannel.Configuration().setSpeed(speed));
    }

    public void addSpeeds(Collection<? extends SerialChannel.Speed> all) {
        for (SerialChannel.Speed speed : all) {
            this.addSpeed(speed);
        }
    }

    public Map<String, SerialChannel.Speed> configure(List<String> ports, long timeout, TimeUnit unit) throws IOException {
        if (this.configurations.isEmpty()) {
            throw new IllegalArgumentException("no configurations");
        }
        if (this.ranges.isEmpty()) {
            throw new IllegalArgumentException("no ranges");
        }
        long timeLimit = unit.toMillis(timeout) + System.currentTimeMillis();
        HashMap<String, SerialChannel.Speed> map = new HashMap<String, SerialChannel.Speed>();
        SerialSelector selector = SerialSelector.open();
        System.err.println("try " + this.configurations.get(0));
        try (CloseableSet<SerialChannel> channels = this.openAll(ports);){
            for (SerialChannel sc : channels) {
                selector.register(sc, 1, new Ctx(sc.getPort()));
            }
            while (SpeedDetector.hasTimeLeft(timeLimit)) {
                Ctx ctx;
                int count = selector.select(this.waitMillis);
                if (count > 0) {
                    Iterator<SelectionKey> iterator = selector.selectedKeys().iterator();
                    while (iterator.hasNext()) {
                        SelectionKey sk = iterator.next();
                        ctx = (Ctx)sk.attachment();
                        switch (ctx.tryMatch(sk)) {
                            case Success: {
                                map.put(ctx.getPort(), ctx.getConfiguration().getSpeed());
                                sk.cancel();
                                break;
                            }
                            case Fail: {
                                sk.cancel();
                            }
                        }
                        iterator.remove();
                    }
                    continue;
                }
                if (selector.keys().isEmpty()) {
                    break;
                }
                for (SelectionKey sk : selector.keys()) {
                    ctx = (Ctx)sk.attachment();
                    boolean has = ctx.nextConfiguration(sk);
                    if (has) continue;
                    sk.cancel();
                }
            }
        }
        return map;
    }

    private static boolean hasTimeLeft(long timeLimit) {
        return SpeedDetector.timeLeft(timeLimit) > 10L;
    }

    private static long timeLeft(long timeLimit) {
        return timeLimit - System.currentTimeMillis();
    }

    private CloseableSet<SerialChannel> openAll(List<String> ports) throws IOException {
        CloseableSet<SerialChannel> set = new CloseableSet<SerialChannel>();
        SerialChannel.Builder builder = new SerialChannel.Builder("", this.configurations.get(0)).setBlocking(false).setReplaceError(true);
        for (String port : ports) {
            builder.setPort(port);
            set.add(builder.get());
        }
        return set;
    }

    static boolean inRange(Collection<? extends Range> ranges, byte b) {
        for (Range range : ranges) {
            if (!range.in(b)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ List access$200(SpeedDetector x0) {
        return x0.ranges;
    }

    private class CloseableSet<T extends AutoCloseable>
    extends HashSet<T>
    implements AutoCloseable {
        private CloseableSet() {
        }

        @Override
        public void close() throws IOException {
            for (AutoCloseable item : this) {
                try {
                    item.close();
                }
                catch (Exception ex) {
                    if (ex instanceof IOException) {
                        throw (IOException)ex;
                    }
                    throw new IOException(ex);
                }
            }
        }
    }

    public class Range {
        byte start;
        byte end;

        public Range(byte b) {
            this.start = b;
            this.end = b;
        }

        public Range(byte start, byte end) {
            this.start = start;
            this.end = end;
        }

        boolean in(byte b) {
            return b >= this.start && b <= this.end;
        }
    }

    private class Matcher {
        int corrects;
        int errors;
        int count;
        private final List<Range> ranges;

        public Matcher(List<Range> ranges) {
            this.ranges = ranges;
        }

        State match(byte b) {
            if (this.count > SpeedDetector.this.maxCount) {
                return State.Fail;
            }
            ++this.count;
            if (!SpeedDetector.inRange(this.ranges, b)) {
                ++this.errors;
                this.corrects = 0;
                System.err.print(b + "-");
            } else {
                this.errors = 0;
                ++this.corrects;
                System.err.print('+');
            }
            if (this.corrects > SpeedDetector.this.testLength) {
                return State.Success;
            }
            if (this.errors > SpeedDetector.this.testLength) {
                return State.Fail;
            }
            return State.GoOn;
        }

        private void reset() {
            this.errors = 0;
            this.corrects = 0;
            this.count = 0;
        }
    }

    private class Ctx {
        String port;
        int confNo;
        ByteBuffer bb = ByteBuffer.allocate(1000);
        Matcher matcher = new Matcher(SpeedDetector.access$200(SpeedDetector.this));

        public Ctx(String port) {
            this.port = port;
        }

        State tryMatch(SelectionKey sk) throws IOException {
            SerialChannel channel = (SerialChannel)sk.channel();
            this.bb.clear();
            int rc = channel.read(this.bb);
            while (rc > 0) {
                this.bb.flip();
                while (this.bb.hasRemaining()) {
                    State s = this.matcher.match(this.bb.get());
                    switch (s) {
                        case Success: {
                            return s;
                        }
                        case Fail: {
                            if (this.nextConfiguration(sk)) break;
                            return s;
                        }
                    }
                }
                this.bb.clear();
                rc = channel.read(this.bb);
            }
            return State.GoOn;
        }

        SerialChannel.Configuration getConfiguration() {
            return (SerialChannel.Configuration)SpeedDetector.this.configurations.get(this.confNo);
        }

        public String getPort() {
            return this.port;
        }

        private boolean nextConfiguration(SelectionKey sk) throws IOException {
            ++this.confNo;
            if (this.confNo == SpeedDetector.this.configurations.size()) {
                return false;
            }
            SerialChannel channel = (SerialChannel)sk.channel();
            SerialChannel.Configuration conf = (SerialChannel.Configuration)SpeedDetector.this.configurations.get(this.confNo);
            System.err.println("\ntry " + conf);
            channel.configure(conf);
            this.matcher.reset();
            return true;
        }
    }

    private static enum State {
        Success,
        Fail,
        GoOn;

    }
}

