/*
 * Decompiled with CFR 0.152.
 */
package javax.comm;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TooManyListenersException;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.comm.CommDriver;
import javax.comm.CommPort;
import javax.comm.CommPortOwnershipListener;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;
import org.vesalainen.comm.channel.SerialChannel;

public class CommPortIdentifier {
    public static final int PORT_PARALLEL = 2;
    public static final int PORT_SERIAL = 1;
    private final String port;
    private String owner;
    private static final Map<String, CommPortIdentifier> portMap = new WeakHashMap<String, CommPortIdentifier>();
    private static final Map<CommPort, CommPortIdentifier> commPortMap = new WeakHashMap<CommPort, CommPortIdentifier>();
    private final List<CommPortOwnershipListener> listeners = new ArrayList<CommPortOwnershipListener>();
    private final ReentrantLock lock = new ReentrantLock();
    private CommPort commPort;
    private boolean requesting;

    public CommPortIdentifier(String name, CommPort port, int type, CommDriver driver) {
        this.port = name;
    }

    public static Enumeration getPortIdentifiers() {
        ArrayList<CommPortIdentifier> list = new ArrayList<CommPortIdentifier>();
        for (String port : SerialChannel.getAllPorts()) {
            CommPortIdentifier cpi = portMap.get(port);
            if (cpi == null) {
                cpi = new CommPortIdentifier(port, null, 1, null);
                portMap.put(port, cpi);
            }
            list.add(cpi);
        }
        return Collections.enumeration(list);
    }

    public static CommPortIdentifier getPortIdentifier(String portName) throws NoSuchPortException {
        List allPorts = SerialChannel.getAllPorts();
        if (allPorts.contains(portName)) {
            CommPortIdentifier cpi = portMap.get(portName);
            if (cpi == null) {
                cpi = new CommPortIdentifier(portName, null, 1, null);
                portMap.put(portName, cpi);
            }
            return cpi;
        }
        throw new NoSuchPortException(portName);
    }

    public static CommPortIdentifier getPortIdentifier(CommPort port) throws NoSuchPortException {
        CommPortIdentifier cpi = commPortMap.get(port);
        if (cpi != null) {
            return cpi;
        }
        throw new NoSuchPortException();
    }

    public static void addPortName(String portName, int portType, CommDriver driver) {
        throw new UnsupportedOperationException("not supported");
    }

    public CommPort open(String appname, int timeout) throws PortInUseException {
        this.lock.lock();
        try {
            if (this.owner == null) {
                this.owner = appname;
                this.commPort = new SerialPortImpl();
                commPortMap.put(this.commPort, this);
                this.fireListener(1);
                CommPort commPort = this.commPort;
                return commPort;
            }
            if (this.owner.equals(appname)) {
                CommPort commPort = this.commPort;
                return commPort;
            }
            this.requesting = true;
            this.fireListener(3);
            this.requesting = false;
            if (this.owner == null) {
                this.owner = appname;
                this.commPort = new SerialPortImpl();
                commPortMap.put(this.commPort, this);
                CommPort commPort = this.commPort;
                return commPort;
            }
            throw new PortInUseException(this.port);
        }
        finally {
            this.lock.unlock();
        }
    }

    public CommPort open(FileDescriptor fd) throws UnsupportedCommOperationException {
        throw new UnsupportedOperationException("not supported");
    }

    public String getName() {
        return this.port;
    }

    public int getPortType() {
        return 1;
    }

    public String getCurrentOwner() {
        return this.owner;
    }

    public boolean isCurrentlyOwned() {
        return this.owner != null;
    }

    public void addPortOwnershipListener(CommPortOwnershipListener listener) {
        this.listeners.add(listener);
    }

    public void removePortOwnershipListener(CommPortOwnershipListener listener) {
        this.listeners.remove(listener);
    }

    private void fireListener(int event) {
        for (CommPortOwnershipListener l : this.listeners) {
            l.ownershipChange(event);
        }
    }

    public class SerialPortImpl
    extends SerialPort {
        private final SerialChannel.Configuration config;
        private SerialChannel channel;
        private int inputBufferSize = 4096;
        private int outputBufferSize = 4096;
        private InputStream in;
        private OutputStream out;

        public SerialPortImpl() {
            this.name = CommPortIdentifier.this.port;
            this.config = new SerialChannel.Configuration();
            this.config.setSpeed(SerialChannel.Speed.B9600);
        }

        @Override
        public void close() {
            CommPortIdentifier.this.lock.lock();
            try {
                this.channel.close();
                CommPortIdentifier.this.commPort = null;
                CommPortIdentifier.this.owner = null;
                commPortMap.remove(this);
                if (!CommPortIdentifier.this.requesting) {
                    CommPortIdentifier.this.fireListener(2);
                }
            }
            catch (IOException ex) {
                throw new IllegalArgumentException(ex);
            }
            finally {
                CommPortIdentifier.this.lock.unlock();
            }
        }

        @Override
        public int getBaudRate() {
            return SerialChannel.getSpeed((SerialChannel.Speed)this.config.getSpeed());
        }

        @Override
        public int getDataBits() {
            switch (this.config.getDataBits()) {
                case DATABITS_5: {
                    return 5;
                }
                case DATABITS_6: {
                    return 6;
                }
                case DATABITS_7: {
                    return 7;
                }
                case DATABITS_8: {
                    return 8;
                }
            }
            throw new UnsupportedOperationException(this.config.getDataBits() + " not supported");
        }

        @Override
        public int getStopBits() {
            switch (this.config.getStopBits()) {
                case STOPBITS_1: {
                    return 1;
                }
                case STOPBITS_2: {
                    return 2;
                }
                case STOPBITS_1_5: {
                    return 3;
                }
            }
            throw new UnsupportedOperationException(this.config.getStopBits() + " not supported");
        }

        @Override
        public int getParity() {
            switch (this.config.getParity()) {
                case NONE: {
                    return 0;
                }
                case EVEN: {
                    return 2;
                }
                case ODD: {
                    return 1;
                }
                case SPACE: {
                    return 4;
                }
                case MARK: {
                    return 3;
                }
            }
            throw new UnsupportedOperationException(this.config.getParity() + " not supported");
        }

        @Override
        public void sendBreak(int millis) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void setFlowControlMode(int flowcontrol) throws UnsupportedCommOperationException {
            switch (flowcontrol) {
                case 0: {
                    this.config.setFlowControl(SerialChannel.FlowControl.NONE);
                    break;
                }
                case 3: {
                    this.config.setFlowControl(SerialChannel.FlowControl.RTSCTS);
                    break;
                }
                case 12: {
                    this.config.setFlowControl(SerialChannel.FlowControl.XONXOFF);
                    break;
                }
                default: {
                    throw new UnsupportedCommOperationException(flowcontrol + " not supported");
                }
            }
        }

        @Override
        public int getFlowControlMode() {
            switch (this.config.getFlowControl()) {
                case NONE: {
                    return 0;
                }
                case RTSCTS: {
                    return 3;
                }
                case XONXOFF: {
                    return 12;
                }
            }
            throw new UnsupportedOperationException(this.config.getFlowControl() + " not supported");
        }

        @Override
        public void setSerialPortParams(int baudrate, int dataBits, int stopBits, int parity) throws UnsupportedCommOperationException {
            try {
                this.config.setSpeed(SerialChannel.getSpeed((int)baudrate));
                switch (dataBits) {
                    case 5: {
                        this.config.setDataBits(SerialChannel.DataBits.DATABITS_5);
                        break;
                    }
                    case 6: {
                        this.config.setDataBits(SerialChannel.DataBits.DATABITS_6);
                        break;
                    }
                    case 7: {
                        this.config.setDataBits(SerialChannel.DataBits.DATABITS_7);
                        break;
                    }
                    case 8: {
                        this.config.setDataBits(SerialChannel.DataBits.DATABITS_8);
                        break;
                    }
                    default: {
                        throw new UnsupportedCommOperationException("dataBits " + dataBits + " not supported");
                    }
                }
                switch (stopBits) {
                    case 1: {
                        this.config.setStopBits(SerialChannel.StopBits.STOPBITS_1);
                        break;
                    }
                    case 2: {
                        this.config.setStopBits(SerialChannel.StopBits.STOPBITS_2);
                        break;
                    }
                    case 3: {
                        this.config.setStopBits(SerialChannel.StopBits.STOPBITS_1_5);
                        break;
                    }
                    default: {
                        throw new UnsupportedCommOperationException("stopBits " + stopBits + " not supported");
                    }
                }
                switch (parity) {
                    case 0: {
                        this.config.setParity(SerialChannel.Parity.NONE);
                        break;
                    }
                    case 2: {
                        this.config.setParity(SerialChannel.Parity.EVEN);
                        break;
                    }
                    case 1: {
                        this.config.setParity(SerialChannel.Parity.ODD);
                        break;
                    }
                    case 4: {
                        this.config.setParity(SerialChannel.Parity.SPACE);
                        break;
                    }
                    case 3: {
                        this.config.setParity(SerialChannel.Parity.MARK);
                        break;
                    }
                    default: {
                        throw new UnsupportedCommOperationException("parity " + parity + " not supported");
                    }
                }
            }
            catch (Exception ex) {
                throw new UnsupportedCommOperationException(ex.getMessage());
            }
        }

        @Override
        public void setDTR(boolean dtr) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isDTR() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void setRTS(boolean rts) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isRTS() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isCTS() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isDSR() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isRI() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isCD() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void addEventListener(SerialPortEventListener lsnr) throws TooManyListenersException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void removeEventListener() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void notifyOnDataAvailable(boolean enable) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void notifyOnOutputEmpty(boolean enable) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void notifyOnCTS(boolean enable) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void notifyOnDSR(boolean enable) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void notifyOnRingIndicator(boolean enable) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void notifyOnCarrierDetect(boolean enable) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void notifyOnOverrunError(boolean enable) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void notifyOnParityError(boolean enable) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void notifyOnFramingError(boolean enable) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void notifyOnBreakInterrupt(boolean enable) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.ensureOpen();
            if (this.in == null) {
                this.in = this.channel.getInputStream(this.inputBufferSize);
            }
            return this.in;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            this.ensureOpen();
            if (this.out == null) {
                this.out = this.channel.getOutputStream(this.outputBufferSize);
            }
            return this.out;
        }

        @Override
        public void enableReceiveThreshold(int thresh) throws UnsupportedCommOperationException {
            throw new UnsupportedCommOperationException("Not supported yet.");
        }

        @Override
        public void disableReceiveThreshold() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isReceiveThresholdEnabled() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getReceiveThreshold() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void enableReceiveTimeout(int rcvTimeout) throws UnsupportedCommOperationException {
            throw new UnsupportedCommOperationException("Not supported yet.");
        }

        @Override
        public void disableReceiveTimeout() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isReceiveTimeoutEnabled() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getReceiveTimeout() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void enableReceiveFraming(int framingByte) throws UnsupportedCommOperationException {
            throw new UnsupportedCommOperationException("Not supported yet.");
        }

        @Override
        public void disableReceiveFraming() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isReceiveFramingEnabled() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getReceiveFramingByte() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void setInputBufferSize(int size) {
            this.inputBufferSize = size;
        }

        @Override
        public int getInputBufferSize() {
            return this.inputBufferSize;
        }

        @Override
        public void setOutputBufferSize(int size) {
            this.outputBufferSize = size;
        }

        @Override
        public int getOutputBufferSize() {
            return this.outputBufferSize;
        }

        private void ensureOpen() throws IOException {
            if (this.channel == null) {
                SerialChannel.Builder builder = new SerialChannel.Builder(this.name, this.config);
                this.channel = builder.get();
            }
        }
    }
}

