/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.bean;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.vesalainen.bean.BeanField;
import org.vesalainen.bean.BeanHelper;
import org.vesalainen.util.ConvertUtility;

public abstract class AbstractBeanField<T, D>
implements BeanField<D> {
    protected Class<?> type;
    protected Field field;
    protected Method getter;
    protected Method setter;

    public AbstractBeanField(T obj, String fieldname) {
        this(obj.getClass(), fieldname);
    }

    public AbstractBeanField(Class<? extends T> cls, String fieldname) {
        try {
            this.field = cls.getField(fieldname);
            this.type = this.field.getType();
        }
        catch (NoSuchFieldException | SecurityException exx) {
            try {
                try {
                    this.getter = cls.getMethod(BeanHelper.getter(fieldname), new Class[0]);
                }
                catch (NoSuchMethodException ex) {
                    try {
                        this.getter = cls.getMethod(BeanHelper.isser(fieldname), new Class[0]);
                    }
                    catch (NoSuchMethodException ex1) {
                        throw new IllegalArgumentException(ex);
                    }
                }
                this.type = this.getter.getReturnType();
                this.setter = cls.getMethod(BeanHelper.setter(fieldname), this.type);
            }
            catch (NoSuchMethodException | SecurityException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }

    @Override
    public void set(Object value) {
        try {
            Object v = ConvertUtility.convert(this.type, value);
            if (this.field != null) {
                this.field.set(this.getBase(), v);
            } else {
                this.setter.invoke(this.getBase(), v);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public D get() {
        try {
            if (this.field != null) {
                return (D)this.field.get(this.getBase());
            }
            return (D)this.getter.invoke(this.getBase(), new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    protected abstract T getBase();
}

