/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.code;

import java.util.Arrays;
import org.vesalainen.code.JavaType;
import org.vesalainen.util.Transactional;

public abstract class AbstractDispatcher
implements Transactional {
    protected final int Size = JavaType.values().length;
    protected Object[] arr = new Object[this.Size];
    protected int[] ord;
    protected int ordInd;
    protected int[] ind = new int[this.Size];

    protected AbstractDispatcher(int[] sizes) {
        if (sizes.length != this.Size) {
            throw new IllegalArgumentException("sizes illegal length");
        }
        int ordSize = 0;
        block11: for (int ii = 0; ii < this.Size; ++ii) {
            if (sizes[ii] <= 0) continue;
            ordSize += sizes[ii];
            JavaType jt = JavaType.values()[ii];
            switch (jt) {
                case BOOLEAN: {
                    this.arr[ii] = new boolean[sizes[ii]];
                    continue block11;
                }
                case BYTE: {
                    this.arr[ii] = new byte[sizes[ii]];
                    continue block11;
                }
                case CHAR: {
                    this.arr[ii] = new char[sizes[ii]];
                    continue block11;
                }
                case SHORT: {
                    this.arr[ii] = new short[sizes[ii]];
                    continue block11;
                }
                case INT: {
                    this.arr[ii] = new int[sizes[ii]];
                    continue block11;
                }
                case LONG: {
                    this.arr[ii] = new long[sizes[ii]];
                    continue block11;
                }
                case FLOAT: {
                    this.arr[ii] = new float[sizes[ii]];
                    continue block11;
                }
                case DOUBLE: {
                    this.arr[ii] = new double[sizes[ii]];
                    continue block11;
                }
                case DECLARED: {
                    this.arr[ii] = new Object[sizes[ii]];
                }
            }
        }
        this.ord = new int[ordSize];
    }

    protected void clear() {
        this.ordInd = 0;
        Arrays.fill(this.ind, 0);
        Arrays.fill((Object[])this.arr[JavaType.DECLARED.ordinal()], (Object)0);
    }

    protected void set(int ordinal, boolean arg) {
        int o = JavaType.BOOLEAN.ordinal();
        this.ord[this.ordInd++] = ordinal;
        ((boolean[])this.arr[o])[this.ind[o]] = arg;
        int n = o;
        this.ind[n] = this.ind[n] + 1;
    }

    protected void set(int ordinal, byte arg) {
        int o = JavaType.BYTE.ordinal();
        this.ord[this.ordInd++] = ordinal;
        ((byte[])this.arr[o])[this.ind[o]] = arg;
        int n = o;
        this.ind[n] = this.ind[n] + 1;
    }

    protected void set(int ordinal, char arg) {
        int o = JavaType.CHAR.ordinal();
        this.ord[this.ordInd++] = ordinal;
        ((char[])this.arr[o])[this.ind[o]] = arg;
        int n = o;
        this.ind[n] = this.ind[n] + 1;
    }

    protected void set(int ordinal, short arg) {
        int o = JavaType.SHORT.ordinal();
        this.ord[this.ordInd++] = ordinal;
        ((short[])this.arr[o])[this.ind[o]] = arg;
        int n = o;
        this.ind[n] = this.ind[n] + 1;
    }

    protected void set(int ordinal, int arg) {
        int o = JavaType.INT.ordinal();
        this.ord[this.ordInd++] = ordinal;
        ((int[])this.arr[o])[this.ind[o]] = arg;
        int n = o;
        this.ind[n] = this.ind[n] + 1;
    }

    protected void set(int ordinal, long arg) {
        int o = JavaType.LONG.ordinal();
        this.ord[this.ordInd++] = ordinal;
        ((long[])this.arr[o])[this.ind[o]] = arg;
        int n = o;
        this.ind[n] = this.ind[n] + 1;
    }

    protected void set(int ordinal, float arg) {
        int o = JavaType.FLOAT.ordinal();
        this.ord[this.ordInd++] = ordinal;
        ((float[])this.arr[o])[this.ind[o]] = arg;
        int n = o;
        this.ind[n] = this.ind[n] + 1;
    }

    protected void set(int ordinal, double arg) {
        int o = JavaType.DOUBLE.ordinal();
        this.ord[this.ordInd++] = ordinal;
        ((double[])this.arr[o])[this.ind[o]] = arg;
        int n = o;
        this.ind[n] = this.ind[n] + 1;
    }

    protected void set(int ordinal, Object arg) {
        int o = JavaType.DECLARED.ordinal();
        this.ord[this.ordInd++] = ordinal;
        ((Object[])this.arr[o])[this.ind[o]] = arg;
        int n = o;
        this.ind[n] = this.ind[n] + 1;
    }
}

