/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.code;

import java.io.IOException;
import java.util.Collection;
import org.vesalainen.code.CodePrinter;

public abstract class ListPrinter<T> {
    protected final CodePrinter out;
    protected final CharSequence separator;
    protected T[] array;
    protected Collection<? extends T> list;

    public ListPrinter(CodePrinter out, CharSequence separator, Collection<? extends T> list) {
        this.out = out;
        this.separator = separator;
        this.list = list;
    }

    public ListPrinter(CodePrinter out, CharSequence separator, T[] array) {
        this.out = out;
        this.separator = separator;
        this.array = array;
    }

    public void print() throws IOException {
        boolean first = true;
        int index = 0;
        if (this.list != null) {
            for (T item : this.list) {
                if (!first) {
                    this.out.print(this.separator);
                }
                first = false;
                this.print(index, item);
                ++index;
            }
        } else {
            for (T item : this.array) {
                if (!first) {
                    this.out.print(this.separator);
                }
                first = false;
                this.print(index, item);
                ++index;
            }
        }
    }

    public void print(CharSequence str) throws IOException {
        this.out.print(str);
    }

    protected abstract void print(int var1, T var2) throws IOException;
}

