/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.code;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.vesalainen.code.BeanProxyClass;
import org.vesalainen.code.CodePrinter;
import org.vesalainen.code.JavaType;
import org.vesalainen.code.PropertyDispatcherClass;
import org.vesalainen.code.TransactionalSetterClass;
import org.vesalainen.util.Transactional;

@SupportedAnnotationTypes(value={"org.vesalainen.code.BeanProxyClass", "org.vesalainen.code.TransactionalSetterClass", "org.vesalainen.code.PropertyDispatcherClass"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class Processor
extends AbstractProcessor {
    private static final Set<String> classnames = new HashSet<String>();
    private static final AtomicInteger sequence = new AtomicInteger();
    private Elements elements;
    private Types types;

    @Override
    public synchronized void init(ProcessingEnvironment pe) {
        super.init(pe);
        this.elements = pe.getElementUtils();
        this.types = pe.getTypeUtils();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Messager msg = this.processingEnv.getMessager();
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                TypeElement type = (TypeElement)element;
                try {
                    msg.printMessage(Diagnostic.Kind.NOTE, "processing", type);
                    System.err.println("processing " + type);
                    switch (typeElement.getQualifiedName().toString()) {
                        case "org.vesalainen.code.BeanProxyClass": {
                            this.generateBeanProxy(type, this.processingEnv);
                            break;
                        }
                        case "org.vesalainen.code.TransactionalSetterClass": {
                            this.generateTransactionalSetter(type, this.processingEnv);
                            break;
                        }
                        case "org.vesalainen.code.PropertyDispatcherClass": {
                            this.generatePropertyDispatcher(type, this.processingEnv);
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException(typeElement.getQualifiedName().toString() + " not supported");
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    String m = ex.getMessage();
                    m = m != null ? m : ex.toString();
                    msg.printMessage(Diagnostic.Kind.ERROR, m, element);
                }
            }
        }
        return true;
    }

    private void generatePropertyDispatcher(TypeElement cls, ProcessingEnvironment processingEnv) throws IOException {
        PropertyDispatcherClass annotation = cls.getAnnotation(PropertyDispatcherClass.class);
        if (annotation == null) {
            throw new IllegalArgumentException("@" + PropertyDispatcherClass.class.getSimpleName() + " missing in cls");
        }
        TypeElement transactional = this.elements.getTypeElement(Transactional.class.getCanonicalName());
        Filer filer = processingEnv.getFiler();
        String value = annotation.value();
        JavaFileObject sourceFile = filer.createSourceFile(value, new Element[0]);
        try (Writer writer = sourceFile.openWriter();){
            CodePrinter mp = new CodePrinter(writer);
            int idx = value.lastIndexOf(46);
            String classname = value.substring(idx + 1);
            String pgk = value.substring(0, idx);
            List<? extends ExecutableElement> methods = this.getMethods(cls);
            List<? extends TypeMirror> interfaces = cls.getInterfaces();
            mp.println("package " + pgk + ";");
            mp.println("import org.vesalainen.util.Transactional;");
            mp.println("import java.util.Arrays;");
            mp.println("import javax.annotation.Generated;");
            mp.println("import org.vesalainen.code.PropertySetterDispatcher;");
            mp.println("@Generated(");
            mp.println("\tvalue=\"" + Processor.class.getCanonicalName() + "\"");
            mp.println("\t, comments=\"Generated for " + cls + "\"");
            Date date = new Date();
            mp.println("\t, date=\"" + date + "\"");
            mp.println(")");
            CodePrinter cp = mp.createClass(EnumSet.of(Modifier.PUBLIC), classname, cls, new TypeElement[0]);
            TreeSet<String> en = new TreeSet<String>();
            Integer[] sizes = new Integer[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
            for (ExecutableElement executableElement : methods) {
                List<? extends VariableElement> parameters = executableElement.getParameters();
                TypeMirror typeMirror = executableElement.getReturnType();
                String name = executableElement.getSimpleName().toString();
                if (!name.startsWith("set") || parameters.size() != 1 || typeMirror.getKind() != TypeKind.VOID) continue;
                en.add(this.getEnum(executableElement));
                try {
                    VariableElement ve = parameters.get(0);
                    TypeMirror tm = ve.asType();
                    TypeKind tk = tm.getKind();
                    JavaType jt = JavaType.valueOf(tk.name());
                    Integer[] integerArray = sizes;
                    int n = jt.ordinal();
                    Integer n2 = integerArray[n];
                    Integer n3 = integerArray[n] = Integer.valueOf(integerArray[n] + 1);
                }
                catch (IllegalArgumentException ve) {}
            }
            cp.print("private enum Prop {");
            cp.print((CharSequence)", ", en);
            cp.println("};");
            cp.println("public " + classname + "()");
            cp.println("{");
            CodePrinter cons1 = cp.createSub("}");
            cons1.print("super(new int[] {");
            cons1.print((CharSequence)", ", sizes);
            cons1.println("});");
            cons1.flush();
            cp.println("public " + classname + "(PropertySetterDispatcher dispatcher)");
            cp.println("{");
            CodePrinter codePrinter = cp.createSub("}");
            codePrinter.print("super(new int[] {");
            codePrinter.print((CharSequence)", ", sizes);
            codePrinter.println("}, dispatcher);");
            codePrinter.flush();
            for (ExecutableElement executableElement : methods) {
                CodePrinter cc;
                CodePrinter ct;
                List<? extends VariableElement> parameters = executableElement.getParameters();
                TypeMirror returnType = executableElement.getReturnType();
                cp.println("@Override");
                String name = executableElement.getSimpleName().toString();
                EnumSet<Modifier> modifiers = EnumSet.of(Modifier.PUBLIC);
                CodePrinter cm = cp.createMethod(modifiers, executableElement);
                if (name.startsWith("set") && parameters.size() == 1 && returnType.getKind() == TypeKind.VOID) {
                    String enumname = this.getEnum(executableElement);
                    String property = this.getProperty(executableElement);
                    VariableElement ve = parameters.get(0);
                    cm.println("if (observers.containsProperty(\"" + property + "\"))");
                    cm.println("{");
                    CodePrinter ifobs = cm.createSub("}");
                    ifobs.println("set(Prop." + enumname + ".ordinal(), " + ve.getSimpleName() + ");");
                    ifobs.flush();
                } else if (name.equals("commit") && parameters.size() == 1 && "java.lang.String".equals(parameters.get(0).asType().toString()) && returnType.getKind() == TypeKind.VOID) {
                    cm.println("try");
                    cm.println("{");
                    ct = cm.createSub("}");
                    ct.println("Arrays.fill(ind, 0);");
                    ct.println("Prop[] values = Prop.values();");
                    ct.println("for (int ii=0;ii<ordInd;ii++)");
                    ct.println("{");
                    cc = ct.createSub("}");
                    cc.println("switch (values[ord[ii]])");
                    cc.println("{");
                    CodePrinter cs = cc.createSub("}");
                    for (ExecutableElement executableElement2 : methods) {
                        List<? extends VariableElement> params = executableElement2.getParameters();
                        TypeMirror rt = executableElement2.getReturnType();
                        String sn = executableElement2.getSimpleName().toString();
                        if (!sn.startsWith("set") || params.size() != 1 || rt.getKind() != TypeKind.VOID) continue;
                        JavaType jt = JavaType.valueOf(params.get(0).asType().getKind().name());
                        String aEnum = this.getEnum(executableElement2);
                        String prop = this.getProperty(sn);
                        cs.println("case " + aEnum + ":");
                        cs.println("{");
                        CodePrinter csw = cs.createSub("}");
                        String code = jt.getCode();
                        int ordinal = jt.ordinal();
                        csw.println(code + "[] a = (" + code + "[])arr[" + ordinal + "];");
                        csw.println("observers.set(\"" + prop + "\", a[ind[" + ordinal + "]]);");
                        csw.println("ind[" + ordinal + "]++;");
                        csw.println("break;");
                        csw.flush();
                    }
                    cs.println("default:");
                    CodePrinter csw = cs.createSub("");
                    csw.println("throw new UnsupportedOperationException(\"should not happen\");");
                    csw.flush();
                    cs.flush();
                    cc.flush();
                    ct.println("for (Transactional tr : transactionalObservers)");
                    ct.println("{");
                    CodePrinter codePrinter2 = ct.createSub("}");
                    codePrinter2.println("tr.commit(" + parameters.get(0).getSimpleName() + ");");
                    codePrinter2.flush();
                    ct.println("clear();");
                    ct.flush();
                    cm.println("finally");
                    cm.println("{");
                    CodePrinter cf = cm.createSub("}");
                    cf.println("semaphore.release();");
                    cf.flush();
                } else if (name.equals("rollback") && parameters.size() == 1 && "java.lang.String".equals(parameters.get(0).asType().toString()) && returnType.getKind() == TypeKind.VOID) {
                    cm.println("try");
                    cm.println("{");
                    ct = cm.createSub("}");
                    ct.println("clear();");
                    ct.println("for (Transactional tr : transactionalObservers)");
                    ct.println("{");
                    CodePrinter ctr = ct.createSub("}");
                    ctr.println("tr.rollback(" + parameters.get(0).getSimpleName() + ");");
                    ctr.flush();
                    ct.flush();
                    cm.println("finally");
                    cm.println("{");
                    CodePrinter cf = cm.createSub("}");
                    cf.println("semaphore.release();");
                    cf.flush();
                } else if (name.equals("start") && parameters.size() == 1 && "java.lang.String".equals(parameters.get(0).asType().toString()) && returnType.getKind() == TypeKind.VOID) {
                    cm.println("try");
                    cm.println("{");
                    CodePrinter cs = cm.createSub("}");
                    cs.println("semaphore.acquire();");
                    cs.flush();
                    cm.println("catch (InterruptedException ex)");
                    cm.println("{");
                    cc = cm.createSub("}");
                    cc.println("throw new IllegalArgumentException(ex);");
                    cc.flush();
                } else {
                    cm.println("throw new UnsupportedOperationException(\"not supported.\");");
                }
                cm.flush();
            }
            cp.flush();
        }
    }

    private void generateTransactionalSetter(TypeElement cls, ProcessingEnvironment processingEnv) throws IOException {
        TransactionalSetterClass annotation = cls.getAnnotation(TransactionalSetterClass.class);
        if (annotation == null) {
            throw new IllegalArgumentException("@" + TransactionalSetterClass.class.getSimpleName() + " missing in cls");
        }
        TypeElement transactional = this.elements.getTypeElement(Transactional.class.getCanonicalName());
        Filer filer = processingEnv.getFiler();
        String value = annotation.value();
        JavaFileObject sourceFile = filer.createSourceFile(value, new Element[0]);
        try (Writer writer = sourceFile.openWriter();){
            CodePrinter mp = new CodePrinter(writer);
            int idx = value.lastIndexOf(46);
            String classname = value.substring(idx + 1);
            String pgk = value.substring(0, idx);
            List<? extends ExecutableElement> methods = this.getMethods(cls);
            List<? extends TypeMirror> interfaces = cls.getInterfaces();
            if (interfaces.size() != 1) {
                throw new IllegalArgumentException("interface count != 1 (=" + interfaces.size() + ")");
            }
            TypeMirror theInterface = interfaces.get(0);
            mp.println("package " + pgk + ";");
            mp.println("import java.util.Arrays;");
            mp.println("import javax.annotation.Generated;");
            mp.println("@Generated(");
            mp.println("\tvalue=\"" + Processor.class.getCanonicalName() + "\"");
            mp.println("\t, comments=\"Generated for " + cls + "\"");
            Date date = new Date();
            mp.println("\t, date=\"" + date + "\"");
            mp.println(")");
            CodePrinter cp = mp.createClass(EnumSet.of(Modifier.PUBLIC), classname, cls, new TypeElement[0]);
            TreeSet<String> en = new TreeSet<String>();
            Integer[] sizes = new Integer[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
            for (ExecutableElement executableElement : methods) {
                List<? extends VariableElement> list = executableElement.getParameters();
                TypeMirror returnType = executableElement.getReturnType();
                String name = executableElement.getSimpleName().toString();
                if (!name.startsWith("set") || list.size() != 1 || returnType.getKind() != TypeKind.VOID) continue;
                en.add(this.getEnum(executableElement));
                try {
                    VariableElement ve = list.get(0);
                    TypeMirror tm = ve.asType();
                    TypeKind tk = tm.getKind();
                    JavaType jt = JavaType.valueOf(tk.name());
                    Integer[] integerArray = sizes;
                    int n = jt.ordinal();
                    Integer n2 = integerArray[n];
                    Integer n3 = integerArray[n] = Integer.valueOf(integerArray[n] + 1);
                }
                catch (IllegalArgumentException ve) {}
            }
            cp.print("private enum Prop {");
            cp.print((CharSequence)", ", en);
            cp.println("};");
            cp.println("public " + classname + "()");
            cp.println("{");
            CodePrinter cons = cp.createSub("}");
            cons.print("super(new int[] {");
            cons.print((CharSequence)", ", sizes);
            cons.println("});");
            cons.flush();
            for (ExecutableElement executableElement : methods) {
                String iname;
                List<? extends VariableElement> parameters = executableElement.getParameters();
                TypeMirror returnType = executableElement.getReturnType();
                cp.println("@Override");
                CodePrinter cm = cp.createMethod(EnumSet.of(Modifier.PUBLIC), executableElement);
                String name = executableElement.getSimpleName().toString();
                String enumname = this.getEnum(executableElement);
                if (name.startsWith("set") && parameters.size() == 1 && returnType.getKind() == TypeKind.VOID) {
                    VariableElement ve = parameters.get(0);
                    cm.println("set(Prop." + enumname + ".ordinal(), " + ve.getSimpleName() + ");");
                } else if (name.equals("commit") && parameters.size() == 1 && "java.lang.String".equals(parameters.get(0).asType().toString()) && returnType.getKind() == TypeKind.VOID) {
                    cm.println("Arrays.fill(ind, 0);");
                    cm.println("Prop[] values = Prop.values();");
                    iname = theInterface.toString();
                    cm.println(iname + " interf = (" + iname + ")intf;");
                    cm.println("for (int ii=0;ii<ordInd;ii++)");
                    cm.println("{");
                    CodePrinter cc = cm.createSub("}");
                    cc.println("switch (values[ord[ii]])");
                    cc.println("{");
                    CodePrinter cs = cc.createSub("}");
                    for (ExecutableElement executableElement2 : methods) {
                        List<? extends VariableElement> params = executableElement2.getParameters();
                        TypeMirror rt = executableElement2.getReturnType();
                        String sn = executableElement2.getSimpleName().toString();
                        if (!sn.startsWith("set") || params.size() != 1 || rt.getKind() != TypeKind.VOID) continue;
                        JavaType jt = JavaType.valueOf(params.get(0).asType().getKind().name());
                        String aEnum = this.getEnum(executableElement2);
                        cs.println("case " + aEnum + ":");
                        cs.println("{");
                        CodePrinter csw = cs.createSub("}");
                        String code = jt.getCode();
                        int ordinal = jt.ordinal();
                        csw.println(code + "[] a = (" + code + "[])arr[" + ordinal + "];");
                        csw.println("interf." + sn + "(" + this.cast(params.get(0).asType()) + "a[ind[" + ordinal + "]++]);");
                        csw.println("break;");
                        csw.flush();
                    }
                    cs.println("default:");
                    CodePrinter csw = cs.createSub("");
                    csw.println("throw new UnsupportedOperationException(\"should not happen\");");
                    csw.flush();
                    cs.flush();
                    cc.flush();
                    cm.println("clear();");
                    if (this.types.isAssignable(theInterface, transactional.asType())) {
                        cm.println("interf.commit(" + parameters.get(0).getSimpleName() + ");");
                    }
                } else if (name.equals("rollback") && parameters.size() == 1 && "java.lang.String".equals(parameters.get(0).asType().toString()) && returnType.getKind() == TypeKind.VOID) {
                    cm.println("clear();");
                    if (this.types.isAssignable(theInterface, transactional.asType())) {
                        iname = theInterface.toString();
                        cm.println(iname + " interf = (" + iname + ")intf;");
                        cm.println("interf.rollback(" + parameters.get(0).getSimpleName() + ");");
                    }
                } else if (!name.equals("start") || parameters.size() != 1 || !"java.lang.String".equals(parameters.get(0).asType().toString()) || returnType.getKind() != TypeKind.VOID) {
                    cm.println("throw new UnsupportedOperationException(\"not supported.\");");
                }
                cm.flush();
            }
            cp.flush();
        }
    }

    private void generateBeanProxy(TypeElement cls, ProcessingEnvironment processingEnv) throws IOException {
        BeanProxyClass annotation = cls.getAnnotation(BeanProxyClass.class);
        if (annotation == null) {
            throw new IllegalArgumentException("@" + BeanProxyClass.class.getSimpleName() + " missing in cls");
        }
        Filer filer = processingEnv.getFiler();
        String value = annotation.value();
        JavaFileObject sourceFile = filer.createSourceFile(value, new Element[0]);
        try (Writer writer = sourceFile.openWriter();){
            CodePrinter mp = new CodePrinter(writer);
            int idx = value.lastIndexOf(46);
            String classname = value.substring(idx + 1);
            String pgk = value.substring(0, idx);
            List<? extends ExecutableElement> methods = this.getMethods(cls);
            mp.println("package " + pgk + ";");
            mp.println("import javax.annotation.Generated;");
            mp.println("@Generated(");
            mp.println("\tvalue=\"" + Processor.class.getCanonicalName() + "\"");
            mp.println("\t, comments=\"Generated for " + cls + "\"");
            Date date = new Date();
            mp.println("\t, date=\"" + date + "\"");
            mp.println(")");
            CodePrinter cp = mp.createClass(EnumSet.of(Modifier.PUBLIC), classname, cls, new TypeElement[0]);
            for (ExecutableElement executableElement : methods) {
                List<? extends VariableElement> parameters = executableElement.getParameters();
                TypeMirror returnType = executableElement.getReturnType();
                cp.println("@Override");
                CodePrinter cm = cp.createMethod(EnumSet.of(Modifier.PUBLIC), executableElement);
                String name = executableElement.getSimpleName().toString();
                String property = this.getProperty(name);
                if (name.startsWith("set") && parameters.size() == 1 && returnType.getKind() == TypeKind.VOID) {
                    VariableElement ve = parameters.get(0);
                    cm.println("set(\"" + property + "\", " + ve.getSimpleName() + ");");
                } else if (name.startsWith("get") && parameters.isEmpty() && returnType.getKind() != TypeKind.VOID) {
                    cm.println("return " + this.cast(returnType) + this.getter(returnType.getKind()) + "(\"" + property + "\");");
                } else {
                    cm.println("throw new UnsupportedOperationException(\"not supported.\");");
                }
                cm.flush();
            }
            cp.flush();
        }
    }

    private List<? extends ExecutableElement> getMethods(TypeElement cls) {
        ArrayList<ExecutableElement> list = new ArrayList<ExecutableElement>();
        for (ExecutableElement m : ElementFilter.methodsIn(this.elements.getAllMembers(cls))) {
            if (!m.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            list.add(m);
        }
        return list;
    }

    private synchronized String getUniqueClassname(String name) {
        String res = name;
        while (classnames.contains(res)) {
            res = name + sequence.incrementAndGet();
        }
        classnames.add(res);
        return res;
    }

    private Set<CharSequence> getImports(List<? extends ExecutableElement> methods) {
        TreeSet<CharSequence> set = new TreeSet<CharSequence>();
        for (ExecutableElement executableElement : methods) {
            Processor.add(set, executableElement.getReturnType());
            for (TypeMirror typeMirror : executableElement.getThrownTypes()) {
                Processor.add(set, typeMirror);
            }
            for (VariableElement variableElement : executableElement.getParameters()) {
                Processor.add(set, variableElement.asType());
            }
        }
        return set;
    }

    private static void add(Set<CharSequence> set, TypeMirror tm) {
        if (tm.getKind() == TypeKind.DECLARED) {
            String cl = tm.toString();
            int idx = cl.lastIndexOf(46);
            if (idx != -1 && "java.lang".equals(cl.substring(0, idx))) {
                return;
            }
            set.add(cl);
        }
    }

    private String getProperty(String name) {
        return Character.toLowerCase(name.charAt(3)) + name.substring(4);
    }

    private String getEnum(ExecutableElement m) {
        String name = m.getSimpleName().toString();
        List<? extends VariableElement> parameters = m.getParameters();
        if (parameters.size() != 1) {
            throw new IllegalArgumentException(m.toString());
        }
        VariableElement ve = parameters.get(0);
        TypeMirror type = ve.asType();
        String typeString = type.toString().replace('.', '_').replace('<', '_').replace('>', '_');
        return name.substring(3) + '_' + typeString;
    }

    private String getProperty(ExecutableElement m) {
        String name = m.getSimpleName().toString();
        return Character.toLowerCase(name.charAt(3)) + name.substring(4);
    }

    private String getter(TypeKind kind) {
        return "get" + this.getTypename(kind);
    }

    private String getTypename(TypeKind kind) {
        switch (kind) {
            case ARRAY: 
            case DECLARED: {
                return "Object";
            }
            case BOOLEAN: {
                return "Boolean";
            }
            case BYTE: {
                return "Byte";
            }
            case CHAR: {
                return "Char";
            }
            case DOUBLE: {
                return "Double";
            }
            case FLOAT: {
                return "Float";
            }
            case INT: {
                return "Int";
            }
            case LONG: {
                return "Long";
            }
            case SHORT: {
                return "Short";
            }
        }
        throw new IllegalArgumentException("not type " + (Object)((Object)kind));
    }

    private String cast(TypeMirror tm) {
        switch (tm.getKind()) {
            case ARRAY: 
            case DECLARED: {
                return "(" + tm.toString() + ")";
            }
        }
        return "";
    }
}

