/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.code;

import java.util.concurrent.Semaphore;
import org.vesalainen.code.JavaType;
import org.vesalainen.code.PropertySetter;

public class PropertyBuffer
implements PropertySetter,
Runnable {
    protected Semaphore semaphore = new Semaphore(0);
    protected Thread thread;
    protected PropertySetter observer;
    protected int capacity;
    protected int count;
    protected int index;
    protected JavaType[] typeArr;
    protected String[] propertyArr;
    protected boolean[] booleanArr;
    protected byte[] byteArr;
    protected char[] charArr;
    protected short[] shortArr;
    protected int[] intArr;
    protected long[] longArr;
    protected float[] floatArr;
    protected double[] doubleArr;
    protected Object[] objectArr;

    public PropertyBuffer(PropertySetter observer, int capacity) {
        this.observer = observer;
        this.capacity = capacity;
        this.count = capacity;
        this.typeArr = new JavaType[capacity];
        this.propertyArr = new String[capacity];
    }

    public void start() {
        this.thread = new Thread((Runnable)this, PropertyBuffer.class.getSimpleName());
        this.thread.start();
    }

    public void stop() {
        this.thread.interrupt();
    }

    @Override
    public String[] getPrefixes() {
        return this.observer.getPrefixes();
    }

    @Override
    public void set(String property, boolean arg) {
        this.setType(property, JavaType.BOOLEAN);
        this.booleanArr[this.index] = arg;
        this.next();
    }

    @Override
    public void set(String property, byte arg) {
        this.setType(property, JavaType.BYTE);
        this.byteArr[this.index] = arg;
        this.next();
    }

    @Override
    public void set(String property, char arg) {
        this.setType(property, JavaType.CHAR);
        this.charArr[this.index] = arg;
        this.next();
    }

    @Override
    public void set(String property, short arg) {
        this.setType(property, JavaType.SHORT);
        this.shortArr[this.index] = arg;
        this.next();
    }

    @Override
    public void set(String property, int arg) {
        this.setType(property, JavaType.INT);
        this.intArr[this.index] = arg;
        this.next();
    }

    @Override
    public void set(String property, long arg) {
        this.setType(property, JavaType.LONG);
        this.longArr[this.index] = arg;
        this.next();
    }

    @Override
    public void set(String property, float arg) {
        this.setType(property, JavaType.FLOAT);
        this.floatArr[this.index] = arg;
        this.next();
    }

    @Override
    public void set(String property, double arg) {
        this.setType(property, JavaType.DOUBLE);
        this.doubleArr[this.index] = arg;
        this.next();
    }

    @Override
    public void set(String property, Object arg) {
        this.setType(property, JavaType.DECLARED);
        this.objectArr[this.index] = arg;
        this.next();
    }

    @Override
    public void run() {
        int idx = 0;
        try {
            while (true) {
                this.semaphore.acquire();
                switch (this.typeArr[idx]) {
                    case BOOLEAN: {
                        this.observer.set(this.propertyArr[idx], this.booleanArr[idx]);
                        break;
                    }
                    case BYTE: {
                        this.observer.set(this.propertyArr[idx], this.byteArr[idx]);
                        break;
                    }
                    case CHAR: {
                        this.observer.set(this.propertyArr[idx], this.charArr[idx]);
                        break;
                    }
                    case SHORT: {
                        this.observer.set(this.propertyArr[idx], this.shortArr[idx]);
                        break;
                    }
                    case INT: {
                        this.observer.set(this.propertyArr[idx], this.intArr[idx]);
                        break;
                    }
                    case LONG: {
                        this.observer.set(this.propertyArr[idx], this.longArr[idx]);
                        break;
                    }
                    case FLOAT: {
                        this.observer.set(this.propertyArr[idx], this.floatArr[idx]);
                        break;
                    }
                    case DOUBLE: {
                        this.observer.set(this.propertyArr[idx], this.doubleArr[idx]);
                        break;
                    }
                    case DECLARED: {
                        this.observer.set(this.propertyArr[idx], this.objectArr[idx]);
                    }
                }
                ++idx;
                idx %= this.capacity;
                ++this.count;
            }
        }
        catch (InterruptedException ex) {
            return;
        }
    }

    private void setType(String property, JavaType javaType) {
        if (this.count <= 0) {
            throw new IllegalStateException("capacity reached");
        }
        this.propertyArr[this.index] = property;
        switch (javaType) {
            case BOOLEAN: {
                if (this.booleanArr != null) break;
                this.booleanArr = new boolean[this.capacity];
                break;
            }
            case BYTE: {
                if (this.byteArr != null) break;
                this.byteArr = new byte[this.capacity];
                break;
            }
            case CHAR: {
                if (this.charArr != null) break;
                this.charArr = new char[this.capacity];
                break;
            }
            case SHORT: {
                if (this.shortArr != null) break;
                this.shortArr = new short[this.capacity];
                break;
            }
            case INT: {
                if (this.intArr != null) break;
                this.intArr = new int[this.capacity];
                break;
            }
            case LONG: {
                if (this.longArr != null) break;
                this.longArr = new long[this.capacity];
                break;
            }
            case FLOAT: {
                if (this.floatArr != null) break;
                this.floatArr = new float[this.capacity];
                break;
            }
            case DOUBLE: {
                if (this.doubleArr != null) break;
                this.doubleArr = new double[this.capacity];
                break;
            }
            case DECLARED: {
                if (this.objectArr != null) break;
                this.objectArr = new Object[this.capacity];
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.typeArr[this.index] = javaType;
    }

    private void next() {
        ++this.index;
        this.index %= this.capacity;
        --this.count;
        this.semaphore.release();
    }
}

