/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.code;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.vesalainen.code.AbstractDispatcher;
import org.vesalainen.code.PropertyDispatcherClass;
import org.vesalainen.code.PropertySetter;
import org.vesalainen.code.PropertySetterDispatcher;
import org.vesalainen.code.SimplePropertySetterDispatcher;
import org.vesalainen.util.Transactional;

public abstract class PropertyDispatcher
extends AbstractDispatcher {
    protected List<Transactional> transactionalObservers = new ArrayList<Transactional>();
    protected Semaphore semaphore = new Semaphore(1);
    protected PropertySetterDispatcher observers;

    protected PropertyDispatcher(int[] sizes) {
        this(sizes, new SimplePropertySetterDispatcher());
    }

    protected PropertyDispatcher(int[] sizes, PropertySetterDispatcher observers) {
        super(sizes);
        this.observers = observers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(PropertySetter observer, String ... properties) {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException ex) {
            throw new IllegalArgumentException(ex);
        }
        try {
            this.addObserver(observer);
            for (String p : properties) {
                this.observers.addObserver(p, observer);
            }
        }
        finally {
            this.semaphore.release();
        }
    }

    protected void addObserver(PropertySetter observer) {
        if (observer instanceof Transactional) {
            Transactional tr = (Transactional)((Object)observer);
            this.transactionalObservers.add(tr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserver(PropertySetter observer, String ... properties) {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException ex) {
            throw new IllegalArgumentException(ex);
        }
        try {
            this.removeObserver(observer);
            for (String p : properties) {
                this.observers.removeObserver(p, observer);
            }
        }
        finally {
            this.semaphore.release();
        }
    }

    protected void removeObserver(PropertySetter observer) {
        if (observer instanceof Transactional) {
            Transactional tr = (Transactional)((Object)observer);
            this.transactionalObservers.remove(tr);
        }
    }

    public boolean hasObservers() {
        return !this.observers.isEmpty();
    }

    public static <T extends PropertyDispatcher> T getInstance(Class<T> cls) {
        return PropertyDispatcher.getInstance(cls, null);
    }

    public static <T extends PropertyDispatcher> T getInstance(Class<T> cls, PropertySetterDispatcher dispatcher) {
        try {
            PropertyDispatcherClass annotation = cls.getAnnotation(PropertyDispatcherClass.class);
            if (annotation == null) {
                throw new IllegalArgumentException("@" + PropertyDispatcherClass.class.getSimpleName() + " missing in cls");
            }
            Class<?> c = Class.forName(annotation.value());
            if (dispatcher == null) {
                PropertyDispatcher t = (PropertyDispatcher)c.newInstance();
                return (T)t;
            }
            Constructor<?> constructor = c.getConstructor(PropertySetterDispatcher.class);
            return (T)((PropertyDispatcher)constructor.newInstance(dispatcher));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

