/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.io;

import java.io.IOException;
import java.util.Locale;

public class AppendablePrinter
implements Appendable {
    protected Appendable out;
    protected String eol;

    public AppendablePrinter(Appendable out) {
        this(out, "\n");
    }

    public AppendablePrinter(Appendable out, String endOfLine) {
        this.out = out;
        this.eol = endOfLine;
    }

    @Override
    public Appendable append(CharSequence csq) {
        try {
            return this.out.append(csq);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) {
        try {
            return this.out.append(csq, start, end);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public Appendable append(char c) {
        try {
            return this.out.append(c);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void format(String format, Object ... args) {
        try {
            this.out.append(String.format(format, args));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void format(Locale l, String format, Object ... args) {
        try {
            this.out.append(String.format(l, format, args));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void print(boolean b) {
        try {
            this.out.append(Boolean.toString(b));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void print(char c) {
        try {
            this.out.append(c);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void print(int i) {
        try {
            this.out.append(Integer.toString(i));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void print(long l) {
        try {
            this.out.append(Long.toString(l));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void print(float f) {
        try {
            this.out.append(Float.toString(f));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void print(double d) {
        try {
            this.out.append(Double.toString(d));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void print(char[] s) {
        try {
            for (char cc : s) {
                this.out.append(cc);
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void print(String s) {
        try {
            this.out.append(s);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void print(Object obj) {
        try {
            this.out.append(obj.toString());
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void printf(String format, Object ... args) {
        try {
            this.out.append(String.format(format, args));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void printf(Locale l, String format, Object ... args) {
        try {
            this.out.append(String.format(l, format, args));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void println() {
        try {
            this.out.append(this.eol);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void println(boolean b) {
        try {
            this.out.append(Boolean.toString(b)).append(this.eol);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void println(char c) {
        try {
            this.out.append(c).append(this.eol);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void println(int i) {
        try {
            this.out.append(Integer.toString(i)).append(this.eol);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void println(long l) {
        try {
            this.out.append(Long.toString(l)).append(this.eol);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void println(float f) {
        try {
            this.out.append(Float.toString(f)).append(this.eol);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void println(double d) {
        try {
            this.out.append(Double.toString(d)).append(this.eol);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void println(char[] s) {
        try {
            for (char cc : s) {
                this.out.append(cc);
            }
            this.out.append(this.eol);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void println(String s) {
        try {
            this.out.append(s).append(this.eol);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void println(Object obj) {
        try {
            this.out.append(obj.toString()).append(this.eol);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

