/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.io;

import java.lang.reflect.Field;
import java.util.UUID;
import org.vesalainen.util.BitArray;

public abstract class CompressedIO<T>
implements AutoCloseable {
    protected final T obj;
    protected final Class<? extends Object> cls;
    protected byte[] buf1;
    protected byte[] bits;
    protected BitArray bitArray;
    protected Field[] fields;
    protected int bytes;
    protected UUID uuid;

    public CompressedIO(T obj) {
        this.obj = obj;
        this.cls = obj.getClass();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    protected int getBytes(String type) {
        switch (type) {
            case "boolean": 
            case "byte": {
                return 1;
            }
            case "char": 
            case "short": {
                return 2;
            }
            case "int": 
            case "float": {
                return 4;
            }
            case "long": 
            case "double": {
                return 8;
            }
        }
        throw new IllegalArgumentException(type + " not allowed");
    }
}

