/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.UUID;
import org.vesalainen.io.CompressedIO;
import org.vesalainen.util.BitArray;

public class CompressedInput<T>
extends CompressedIO<T> {
    private final InputStream in;
    private final DataInputStream dis;
    private final ArrayInputStream array;
    private final DataInputStream data;

    public CompressedInput(InputStream in, T obj) throws IOException {
        super(obj);
        Field[] flds;
        this.in = in;
        this.dis = new DataInputStream(in);
        String classname = this.dis.readUTF();
        if (!this.cls.getName().equals(classname)) {
            throw new IOException("Data input from " + classname + " not from " + this.cls);
        }
        int fieldCount = this.dis.readShort();
        if (fieldCount != (flds = this.cls.getFields()).length) {
            throw new IOException("Field count " + fieldCount + " differs from " + this.fields.length);
        }
        this.fields = new Field[fieldCount];
        for (int ii = 0; ii < fieldCount; ++ii) {
            String fieldName = this.dis.readUTF();
            String fieldType = this.dis.readUTF();
            Field fld = null;
            for (Field f : flds) {
                if (!f.getName().equals(fieldName)) continue;
                fld = f;
                break;
            }
            if (fld == null) {
                throw new IOException("Field " + fieldName + " not found ");
            }
            if (!fld.getType().getName().equals(fieldType)) {
                throw new IOException("Field " + fieldName + " type differs " + fieldType + " <> " + fld);
            }
            this.fields[ii] = fld;
        }
        long mostSigBits = this.dis.readLong();
        long leastSigBits = this.dis.readLong();
        this.uuid = new UUID(mostSigBits, leastSigBits);
        for (Field field : this.fields) {
            Class<?> type = field.getType();
            this.bytes += this.getBytes(type.getName());
        }
        this.buf1 = new byte[this.bytes];
        this.array = new ArrayInputStream(this.buf1);
        this.data = new DataInputStream(this.array);
        this.bitArray = new BitArray(this.bytes);
        this.bits = this.bitArray.getArray();
    }

    public float read() throws IOException {
        this.dis.readFully(this.bits);
        int cnt = 0;
        for (int ii = 0; ii < this.bytes; ++ii) {
            if (!this.bitArray.isSet(ii)) continue;
            this.buf1[ii] = this.dis.readByte();
            ++cnt;
        }
        this.array.reset();
        for (Field fld : this.fields) {
            this.read(this.data, fld);
        }
        return (float)cnt / (float)this.bytes;
    }

    private void read(DataInputStream ds, Field field) throws IOException {
        try {
            switch (field.getType().getName()) {
                case "boolean": {
                    field.setBoolean(this.obj, ds.readBoolean());
                    break;
                }
                case "byte": {
                    field.setByte(this.obj, ds.readByte());
                    break;
                }
                case "char": {
                    field.setChar(this.obj, ds.readChar());
                    break;
                }
                case "short": {
                    field.setShort(this.obj, ds.readShort());
                    break;
                }
                case "int": {
                    field.setInt(this.obj, ds.readInt());
                    break;
                }
                case "float": {
                    field.setFloat(this.obj, ds.readFloat());
                    break;
                }
                case "long": {
                    field.setLong(this.obj, ds.readLong());
                    break;
                }
                case "double": {
                    field.setDouble(this.obj, ds.readDouble());
                    break;
                }
                default: {
                    throw new IllegalArgumentException(field + " not allowed");
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    private class ArrayInputStream
    extends InputStream {
        private final byte[] array;
        private int index;

        public ArrayInputStream(byte[] array) {
            this.array = array;
        }

        @Override
        public int read() throws IOException {
            return this.array[this.index++] & 0xFF;
        }

        @Override
        public void reset() {
            this.index = 0;
        }
    }
}

