/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.UUID;
import org.vesalainen.io.CompressedIO;
import org.vesalainen.util.BitArray;

public class CompressedOutput<T>
extends CompressedIO<T> {
    private final byte[] buf2;
    private DataOutputStream dos;
    private OutputStream out;
    private ArrayOutputStream array;
    private DataOutputStream data;

    public CompressedOutput(OutputStream out, T obj) throws IOException {
        super(obj);
        this.out = out;
        this.uuid = UUID.randomUUID();
        for (Field field : this.fields = this.cls.getFields()) {
            Class<?> type = field.getType();
            this.bytes += this.getBytes(type.getName());
        }
        this.buf1 = new byte[this.bytes];
        this.buf2 = new byte[this.bytes];
        this.bitArray = new BitArray(this.bytes);
        this.bits = this.bitArray.getArray();
    }

    public float write() throws IOException {
        if (this.dos == null) {
            this.dos = new DataOutputStream(this.out);
            this.array = new ArrayOutputStream(this.buf1);
            this.data = new DataOutputStream(this.array);
            this.dos.writeUTF(this.cls.getName());
            this.dos.writeShort(this.fields.length);
            for (Field field : this.fields) {
                Class<?> type = field.getType();
                this.dos.writeUTF(field.getName());
                this.dos.writeUTF(type.getName());
            }
            this.dos.writeLong(this.uuid.getMostSignificantBits());
            this.dos.writeLong(this.uuid.getLeastSignificantBits());
        }
        this.array.reset();
        for (Field field : this.fields) {
            this.write(this.data, field);
        }
        for (int ii = 0; ii < this.bytes; ++ii) {
            this.bitArray.set(ii, this.buf1[ii] != this.buf2[ii]);
        }
        this.dos.write(this.bits);
        int cnt = 0;
        for (int ii = 0; ii < this.bytes; ++ii) {
            if (!this.bitArray.isSet(ii)) continue;
            this.dos.write(this.buf1[ii]);
            this.buf2[ii] = this.buf1[ii];
            ++cnt;
        }
        return (float)cnt / (float)this.bytes;
    }

    private void write(DataOutputStream dos, Field field) throws IOException {
        try {
            switch (field.getType().getName()) {
                case "boolean": {
                    dos.writeBoolean(field.getBoolean(this.obj));
                    break;
                }
                case "byte": {
                    dos.writeByte(field.getByte(this.obj));
                    break;
                }
                case "char": {
                    dos.writeChar(field.getChar(this.obj));
                    break;
                }
                case "short": {
                    dos.writeShort(field.getShort(this.obj));
                    break;
                }
                case "int": {
                    dos.writeInt(field.getInt(this.obj));
                    break;
                }
                case "float": {
                    dos.writeFloat(field.getFloat(this.obj));
                    break;
                }
                case "long": {
                    dos.writeLong(field.getLong(this.obj));
                    break;
                }
                case "double": {
                    dos.writeDouble(field.getDouble(this.obj));
                    break;
                }
                default: {
                    throw new IllegalArgumentException(field + " not allowed");
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public boolean hasData() {
        return this.dos != null;
    }

    private class ArrayOutputStream
    extends OutputStream {
        private byte[] buffer;
        private int idx;

        public ArrayOutputStream(byte[] buffer) {
            this.buffer = buffer;
        }

        @Override
        public void write(int b) throws IOException {
            this.buffer[this.idx++] = (byte)b;
        }

        public void reset() {
            this.idx = 0;
        }
    }
}

